
//	module		: poisson eqn with Dirichlet B.C.
//	file name	: testcase_1.cpp
//	version		: 1.0
//	author		: Lung Sheng Chien
//	date		: 2004 / 1 / 26
//
//	description :   Dx2 u = f   on [0,1]
//					Dirichlet B.C.
//				use std 3 point stencil
//  
//	2004/1/30	Lung Sheng		configure random coefficient, result satisfies maximum principle
//
#include "def.h"
#include "cg_1d_array.h"
#include <math.h>
#include "testcase_1.h"
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

void testcase_1_gen_operator(int nx , double dx , linear_eqn *A )
{
	int i ;
	int	x ;
	FILE * fout ;
	
	fout = fopen("fort.43","w+");
	assert(fout) ;

	A[0].coeff[0] = 0 ;
	A[0].coeff[1] = 0 ;
	A[0].coeff[2] = 1.0 ;
	
	fprintf(fout,"1.0\n");
	for(i=1 ; i <= nx-1 ; i++){
/*
		A[i].coeff[0] = - 2.0 / (dx*dx) ;
		A[i].coeff[1] = 1.0 / (dx*dx) ;
		A[i].coeff[2] = 1.0 / (dx*dx) ;
*/
		x = rand() % 100 + 1 ;
		A[i].coeff[1] = A[i-1].coeff[2] ;
		A[i].coeff[2] = ((double) x ) ;
		A[i].coeff[0] = - ( A[i].coeff[1] + A[i].coeff[2] ) ; 
		fprintf(fout,"%g\n", A[i].coeff[2] );
	}
	fprintf(fout,"0\n");
	A[1].coeff[1] = 0.0 ;
	A[nx-1].coeff[2] = 0.0 ;
//	A[nx-1].coeff[0] = - ( A[nx-1].coeff[1] + A[nx-1].coeff[2] )   ;

	fclose(fout);
}

void testcase_1_gen_u_f(int nx , double dx , double* u, double* f ) 
{
	int i  ;
	double x ;
	

	for(i=0 ; i <= nx ; i++){
		x = dx*i ;
//		u[i] = (x - 0.5)*(x-0.5) ;
//		f[i] = 2 ;
		u[i] = 0 ;
		f[i] = 0 ;
	}
	f[(int)nx/4] = 1 ;
}

void  testcase_1_setup_bc(int nx , double dx , double* u , double * f
						  , double *x , double *b)
{
//	int i ;

	x[0]  = u[0] ;
	x[nx] = u[nx] ;
	
	b[1]    = b[1]		- u[0]/(dx*dx) ;
	b[nx-1] = b[nx-1]	- u[nx]/(dx*dx) ;
	
}


void	testcase_1_setup_init(int nx , double dx , double* u , double* f, double * x, double *b) 
{
	int i ;
	
	for(i=1 ; i <= nx-1 ; i++){
		x[i] = 0 ;
		b[i] = f[i] ;
	}
}