
//	module		: header file of linear equation 
//	file name	: cg_1d_list.h
//	version		: 1.0
//	author		: Lung Sheng Chien
//	date		: 2004 / 1 / 26
//  
//  
//	description : 
//				A x = b  for poisson solver std stencil 
//	A (ei) denotes coefficient of i-th equation
//	A.coeff[0]  denotes coefficient of x(i)
//	A.coeff[1]  denotes coefficient of x(i-1)
//  A.coeff[2]  denotes coefficient of x(i+1)
//	ex.  Laplace u = f  over [0,1]  
//		( u(i-1) - 2u(i) + u(i+1) )/h^2 = f(i)		
//					| x(i-1) |
//		[ 1	-2 1 ]	| x(i)   |  = h^2 f(i)
//					| x(i+1) |
//
int cg_1d_list(int nmax , int nx 
				 , linear_eqn *A , double* x
				 , double* b     , double* r   
				 , double* v     , double* z
				 , int imax , double eps , double delta ) ;

double inner_product(int nmax , int nx , double* x , double* y ) ;

void matrix_vector(int nmax , int nx , linear_eqn* A , double* x , 
				   double* y ) ;
