%  Example of the use of Adapt.  
%  REQUIRES Adapt.m, Add.m, Quad.m, and Xadaptf.m.

global nfeval;

%  Assign limits of integration and error tolerances.

a = 0.0;
b = 1.0;
abserr = 1.e-5;
relerr = 1.e-8;

%  Use nfeval to count the number of f evaluations by Adapt.

nfeval = 0;   %  global variable to count function evaluations.


%  Use Adapt to estimate integral of the function defined by f.

[answer,errest,flag] = Adapt('Xadaptf',a,b,abserr,relerr);

%  Print the results.
fprintf('flag = %i\n',flag);
fprintf('Approximate value of the integral = %f\n',answer);
fprintf('Error in answer is approximately %e\n',errest);
fprintf('%i integrand evaluations were required.\n',nfeval);

