************************************************************************
*   FUNCTION:  Driver for using adaptive quadrature routines.          *
*   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for    *
*              the text  Fundamentals of Numerical Computing           *
*   DATE:      June 25, 1994                                           *
************************************************************************
C     Program to illustrate ADAPT.
C
      DOUBLE PRECISION A,B,ABSERR,RELERR,ANSWER,ERREST,F
      INTEGER FLAG,NFEVAL
      EXTERNAL F
C
C     Define labelled COMMON for the global variable NFEVAL.
C
      COMMON /G_ADAPT/ NFEVAL
C
C     Assign limits of integration and error tolerances.
C
      A = 0.D0
      B = 1.D0
      ABSERR = 1.D-5
      RELERR = 1.D-8
C
C     Use NFEVAL to count the number of F evaluations by ADAPT.
C
      NFEVAL = 0
C
C     Use ADAPT to estimate integral of the function defined by F.
C
      CALL ADAPT(F,A,B,ABSERR,RELERR,ANSWER,ERREST,FLAG)
C
C     Check FLAG and print the results.
C
      IF (FLAG .EQ. -1) THEN
         PRINT *,' Invalid input parameters'
      ELSE
         PRINT *,' FLAG =',FLAG
         PRINT *,' Approximate value of the integral =',ANSWER
         PRINT *,' Error in ANSWER is approximately   ',ERREST
         PRINT *,NFEVAL,' integrand evaluations were required.' 
      ENDIF
      STOP
      END
C-----------------------------------------------------------------------
      DOUBLE PRECISION FUNCTION F(X)
      DOUBLE PRECISION X
      INTEGER NFEVAL
      COMMON /G_ADAPT/ NFEVAL
C
      F = EXP(X)
      NFEVAL = NFEVAL+1
      RETURN
      END
C=======================================================================