// FUNCTION:  Driver for using adaptive quadrature routines.
// AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
//            the text  Fundamentals of Numerical Computing
// DATE:      December 6, 1995

#include "fnc.h"

#include <iostream.h>
#include <iomanip.h>
#include <math.h>

//  Declare the prototype for the integrand.

double f(double);

//  Declare the global variable n_func.

int num_f_evals;

void main()
{
    double a, b, abserr, relerr, answer, errest;
    int flag;

//  Set output formatting.

    cout.setf(ios::scientific);   // Use scientific notation.
    cout.precision(15);           // Show all digits.

//  Assign limits of integration and error tolerances.

    a = 0.0;
    b = 1.0;
    abserr = 1.e-5;
    relerr = 1.e-8;

//  Use num_f_evals to count the number of f evaluations by Adapt.

    num_f_evals = 0;

//  Use Adapt to estimate integral of the function defined by f.

    flag = Adapt(f, a, b, abserr, relerr, answer, errest);

//  Check flag and print the results.

    if (flag == -1)
       cout << "\n Invalid input parameters" << endl;
    else
    {
       cout << "\n Flag = " << flag << endl <<
               " Approximate value of the integral = "
            << setw(19) << answer << endl
            << " Error in answer is approximately " << setw(24)
            << errest << endl << setw(11) << num_f_evals
            << " integrand evaluations were required." << endl;
    }
}

double f(double x)
{
    num_f_evals++;
    return exp(x);
}
