// FUNCTION:  This is the header file for the C++ codes accompanying the
//            text  Fundamentals of Numerical Computing.
// AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
// DATE:      December 8, 1995


//    Declare the functions defined in "fnc_util.cpp".

extern double abs_d(double);
extern double max_d(double, double);
extern double min_d(double, double);
extern double sign(double, double);

//    Declare the structure used in Adapt.

#ifndef QUADNODE_H
#define QUADNODE_H
struct QuadNode
{
    double Q;
    double E;
    double alpha;
    double beta;
    QuadNode* Next;
};
#endif

//    Declare the library functions.

extern int Factor(double**, int, double&, int*);
extern void Solve(double**, int, int*, double*);

extern int Spline_coeff(int, double[], double[], double[], double[], double[]);
extern int Spline_value(int, double[], double[], double[], double[], double[], 
                        double, int&, double&);

extern int Zero(double (*)(double), double&, double&, double, double, double&);

extern int Adapt(double(*)(double), double, double, double, double, double&,
                 double&);
extern int Add(QuadNode*, double, double, double, double);
extern void Remove(QuadNode*, double&, double&, double&, double&);
extern void Quad(double(*)(double), double, double, double&, double&, int&);
extern int Empty(QuadNode*);

extern void Rke(void(*)(double, double[], double[]), int, double&, double[],
                double&, int&, double, double[], int&, double&, double[]);
extern void Yvalue(int, double, double, double[], double, double[]);
extern void England(void(*)(double, double[], double[]), double, double[],
                    double[], double[], double[], double[], double, double[],
                    int);
