/* FUNCTION:  Driver for using cubic interpolatory spline routines.
   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
              the text  Fundamentals of Numerical Computing
   DATE:      February 24, 1996                                */

#include "fnc.h"

#include <math.h>        /*   for sin function   */
#include <stdio.h>       /*   for printf   */

void main()
{
   int flag, i, interval, n;
   double b[11], c[11], d[11], f[11], x[11], s, t;
/*
   Assign values for n and the data arrays x and f.
*/
   n = 5;
   for (i = 0; i < n; i++)
   {
      x[i] = 0.20*i;
      f[i] = sin(x[i]);
   }
/*
   Calculate coefficients defining the cubic spline.
*/
   flag = Spline_coeff(n, x, f, b, c, d);
/*
   Check flag, calculate spline values at a few points and
   print the results.
*/
   if (flag != 0)
      printf("\n Error in data, flag = %i",flag);
   else
   {
      for (i = 0; i < 5; i++)
      {
         t = 0.10 + 0.20*i;
         flag = Spline_value(n, x, f, b, c, d, t, &interval, &s);
         printf("t = %18.15e  s = %18.15e flag = %i\n",t,s,flag);
      }
   }
   printf("\n");
}
