PROGRAM X1RKE
!**********************************************************************
!   FUNCTION:  Example of the solution of a system of ordinary        *
!              differential equations.  f90 version.                  *
!   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess        *
!              for the text  Fundamentals of Numerical Computing      *
!   DATE:      January, 1998                                          *
!**********************************************************************

  USE SAP_WP    ! Get working precision WP.
  USE SAP_CODES ! Get RKE subroutine.

  IMPLICIT NONE
  INTEGER, PARAMETER :: NEQ = 2
  REAL (KIND = WP) :: Y(NEQ), YP(NEQ), THRESHOLD(NEQ)
  INTEGER :: NASTEPS, FLAG
  REAL (KIND = WP) :: X, H, TOL, XOUT
  INTERFACE
    FUNCTION F(X,Y) RESULT(YPRIME)
     USE SAP_WP  ! Get working precision WP.
     IMPLICIT NONE
     REAL (KIND = WP), INTENT(IN) :: X
     REAL (KIND = WP), DIMENSION(:), INTENT(IN) :: Y
     REAL (KIND = WP), DIMENSION(SIZE(Y)) :: YPRIME
    END FUNCTION F
  END INTERFACE

  ! Set initial values and tolerances. NEQ has been set as a parameter.
  X = 0.0_WP
  Y(1) = 1.0_WP
  Y(2) = 1.0_WP
  XOUT = 1.0_WP
  H = 0.1_WP
  TOL = 1E-5_WP
  THRESHOLD(1) = 0.0_WP
  THRESHOLD(2) = 1E-5_WP
    
  ! Integration loop.  RKE chooses the step size for efficiency until it is
  ! about to step past XOUT, at which time the step size is reduced to produce
  ! an answer at XOUT. Because the answer is not computed by interpolation, the
  ! optional output arguments STEP and YCOEFF can be omitted from the call list.

  NASTEPS = 0  ! Initialize RKE.
  YP = 0.0_WP
  DO WHILE(X < XOUT)
    IF ((X + H) >= XOUT) THEN
      H = XOUT - X
    END IF
    CALL RKE(F,NEQ,X,Y,YP,H,TOL,THRESHOLD,NASTEPS,FLAG)
    IF (FLAG /= 0) THEN
      WRITE(*,*)' FLAG =',FLAG,' at X =',X
      STOP
    END IF
  END DO

  ! Display the results.
  WRITE(*,*) ' At XOUT = ',XOUT
  WRITE(*,*) ' The numerical solution is ',Y(1),Y(2)
  WRITE(*,*) ' The true solution is      ',EXP(XOUT),EXP(-XOUT)
  STOP
      
END PROGRAM X1RKE

FUNCTION F(X,Y) RESULT(YPRIME)
    
  USE SAP_WP  ! Get working precision WP.
  
  IMPLICIT NONE
  REAL (KIND = WP), INTENT(IN) :: X
  REAL (KIND = WP), DIMENSION(:), INTENT(IN) :: Y
  REAL (KIND = WP), DIMENSION(SIZE(Y)) :: YPRIME

  ! Not using all arguments in a subprogram is a fatal error with the ELF90
  ! compiler, so in the next equation, X is used in a way that has no effect.
  YPRIME(1) =  Y(1)  + 0.0_WP*X
  YPRIME(2) = -Y(2)
  RETURN

END FUNCTION F

