************************************************************************
*   FUNCTION:  Driver for using cubic interpolatory spline routines.   *
*   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for    *
*              the text  Fundamentals of Numerical Computing           *
*   DATE:      June 25, 1994                                           *
************************************************************************
C  Sample program to illustrate routines SPCOEF and SVALUE.
C
      INTEGER FLAG,I,INTERV,N
      DOUBLE PRECISION B(10),C(10),D(10),F(10),X(10),S,T
C
C     Assign values for N and the data arrays X and F.
C
      N = 5
      DO 10 I = 1,N
         X(I) = 0.2D0*(I-1)
         F(I) = SIN(X(I))
   10 CONTINUE
C
C     Calculate coefficients defining the cubic spline.
C
      CALL SPCOEF(N,X,F,B,C,D,FLAG)
C
C     Check FLAG, calculate spline values at a few points and 
C     print the results.
C
      IF (FLAG .NE. 0) THEN
         PRINT *,' Error in data, FLAG =',FLAG
      ELSE
         DO 20 I = 1,5
            T = 0.1D0 + 0.2D0*(I-1)
            CALL SVALUE(N,X,F,B,C,D,T,INTERV,S,FLAG)
            PRINT *,' T =',T,'  S =',S,'  FLAG =',FLAG
   20    CONTINUE
      ENDIF
      STOP
      END
C=======================================================================
