// FUNCTION:  Sample driver for functions Rke and Yvalue.
// AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
//            the text  Fundamentals of Numerical Computing
// DATE:      December 6, 1995
// PURPOSE:   Solve Van der Pol's equation on the interval [0,10] 
//            producing answers at x = 1,2,3,...

#include "fnc.h"

#include <iostream.h>
#include <iomanip.h>

//  Declare prototype for the function describing the ODEs.

void f(double, double[], double[]);

void main()
{
    double x, y[2], h, tol, threshold[2], step, *ycoeff, xout[11], z[2];
    int first, flag, i, neq, nout;
    static int true = 1, false = 0;

//  Set output formatting.

    cout.setf(ios::fixed | ios::showpoint);  // Use fixed point, show decimal.

//  Set initial values and tolerances.

    neq = 2;
    y[0] = 1.0;
    y[1] = 1.0;
    h = 0.1;
    tol = 1.e-5;
    threshold[0] = 1.e-5;
    threshold[1] = 1.e-5;
    first = true;

//  Allocate storage for ycoeff.

    ycoeff = new double[6 * neq];

//  Define the solution output points.

    nout = 11;
    for (i = 0; i < nout; i++) xout[i] = i;

//  Integration loop: call Rke and Yvalue as necessary; h > 0 is assumed.

    x = xout[0];
    for (i = 0; i < nout; i++)
    {
        while (x <= xout[i])
        {
            Rke(f, neq, x, y, h, first, tol, threshold, flag, step, ycoeff);
            if (flag != 0)
            {
               cout << "\n Error at x = " << setw(12) << setprecision(8)
                    << x << "; flag = " << flag << endl;
               return;
            }
        }
        Yvalue(neq, x, step, ycoeff, xout[i], z);
        cout << " Xout = " << setw(5) << setprecision(2) << xout[i]
             << "    Y(1) = " << setw(9) << setprecision(6) << z[0]
             << "    Y(2) = " << setw(9) << setprecision(6) << z[1] << endl;
    }
    cout << endl;
    delete [] ycoeff;
}
///////////////////////////////////////////////////////////////////////////////
void f(double x, double y[], double yprime[])
{
    yprime[0] =  y[1];
    yprime[1] = -y[0] - (y[0] * y[0] - 1.0) * y[1];
    return;
}

