/* FUNCTION:  Driver for using zero finding routines.
   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
              the text  Fundamentals of Numerical Computing
   DATE:      December 6, 1995                                     */

#include "fnc.h"

#include <math.h>      /*   for exp   */
#include <stdio.h>     /*   for printf   */

/*      Give prototype for function whose zero is sought.       */
double f( );

/*      Declare global variables to be passed around Zero.  In this
        example, num_f_evals is used to count the number of evaluations
        of f by Zero.    */
int num_f_evals;

void main()
{
    int flag;
    double b, c, abserr, relerr, residual;
/*
    Assign bracket and error tolerances.
*/
    b = 1.0;
    c = 0.0;
    abserr = 1.e-8;
    relerr = 1.e-6;
/*
    Initialize the count of the number of F evaluations.
*/
    num_f_evals = 0;
/*
    Use Zero to find a root.
*/
    flag = Zero(f, &b, &c, abserr, relerr, &residual);
/*
    Check flag and print results.
*/
    switch (flag)
    {
      case  -2:
         printf("Flag = -2 \n");
         printf("Initial interval [b,c] does not bracket a root.\n");
         break;
      case  -1:
         printf("Flag = -1 \n");
         printf("Error in specifying tolerances. \n");
         break;
      case   1:
         printf("Flag =  1 \n");
         printf("Too much work: num_f_evals = %i \n",num_f_evals);
         printf("There is a root in [b,c] with \n");
         printf("b = %22.15e, c = %22.15e \n",b,c);
         printf("The residual f(b) = %22.15e \n",residual);
         break;
      case   2:
         printf("Flag =  2 \n");
         printf("Computed a pole b = %22.15e \n",b);
         printf("The residual f(b) = %22.15e \n",residual);
         break;
      default:    /*   flag = 0    */
         printf("Flag =  0 \n");
         printf("Computed a root b = %22.15e \n",b);
         printf("The residual f(b) = %22.15e \n",residual);
         printf("%11.1i evaluations of f were required. \n",num_f_evals);
         break;
    }
}

double f(x)
   double x;
{
      num_f_evals++;
      return exp(-x)-2.0*x;
}
