C   A sample code to evaluate Lagrange interpolating polynomials
C   using Neville's method.
C   Improved verion of Algorithm 3.1 of the textbook without Q(:,:).
C   and then modified for matlab reference (index starts from 1).
C   Data from section 3.1, problem 6(a).

        implicit none
        integer i,j,n
        
        real*8 y(1:10)
        real*8 x(1:10)
        real*8 xx
       
        n = 3
        xx = 0.43d0
        do i = 1, n+1
          read (316,*) x(i), y(i)
        enddo
        
        do i = 2, n+1
C ther of the following oth j loops will work
c         do j = 2, i
c           y(i-j+1) = ( (xx-x(i-j+1))*y(i-j+2) - (xx-x(i))*y(i-j+1) )
c    &                /(x(i)-x(i-j+1)) 
c         enddo
          do j = 1, i-1
            y(i-j) = ( (xx-x(i-j))*y(i-j+1) - (xx-x(i))*y(i-j) )
     &                /(x(i)-x(i-j)) 
          enddo
        enddo

        open (12,file='Neville_method_noQ_result.txt')
        write(12,*) 'Nevilles method at x =',xx, 'is', y(1)
        write( 6,*) 'Nevilles method at x =',xx, 'is', y(1)
         
        stop
        end
