C   A sample code to evaluate Lagrange interpolating polynomials
C   using Neville's method. 
C   Improved verion of Algorithm 3.1 of the textbook without Q(:,:).
C   Data from section 3.1, problem 6(a).

        implicit none
        integer i,j,n
        
        real*8 y(0:9)
        real*8 x(0:9)
        real*8 xx
       
        n = 3
        xx = 0.43d0
        do i = 0, n
          read (316,*) x(i), y(i)
        enddo
        
        do i = 1, n
          do j = 1, i
            y(i-j) = ( (xx-x(i-j))*y(i-j+1) - (xx-x(i))*y(i-j) )
     &              /(x(i)-x(i-j)) 
          enddo
        enddo

        open (12,file='Neville_method_noQ_result.txt')
        write(12,*) 'Nevilles method at x =',xx, 'is', y(0)
        write( 6,*) 'Nevilles method at x =',xx, 'is', y(0)
         
        stop
        end
