% Generalized Fixed point method to solve the nonlinear system of equation
% (x-0.01)^2 + y^2 = 1
% x^2 - (y-0.01)^2 = .25
% in the first quadrant (near (1/4, 1/4) := x_0
% Find suitable alpha to minimize g', as in the scalar case.

clear;
format long e;

x = [.5; .5]

i2 = [1 0; 0 1];
J0 =  [ 2*(0.5-0.01) 8*0.5; 2*0.5 -2*(0.5-0.01)] % Jacobian at x_0
K = i2 - J0;
al = K/(K-i2);
% repeat the following command till convergence (about 20+ iterations)

x = al*x  + (i2-al)*( x - [ x(2)^2+4*( x(2)-0.01 )^2-1; x(1)^2-(x(2)-0.01)^2-0.25 ] )

