% V03 of generalized_Fibonacci, written by Wei-Cheng Wang.
% to demonstrate stability and instability of recurrence formula
% this is the case of multiple characteristic root

format long;

n = 100;
% n = 73;

a = zeros(1,n);
ar = zeros(1,n);
a_true = zeros(1,n);

% Example in page 33
a(1) = 1/3; a(2) = -1/3; b = 2; c=-1;
c1 = 1; c2 = -2/3;
for i = 3:n
 a(i) = b*a(i-1) + c*a(i-2);
end

% true solution: 
for i = 1:n
  a_true(i) = c1 + c2*i;
end
% double check if the above calculation is correct.
check_a1 = a(1)-a_true(1)
check_a2 = a(2)-a_true(2)

% relative error for a(n)
check_an = ( a(n)-a_true(n) )
check_an_rel_err = abs( ( a(n)-a_true(n) )/a_true(n) )

rel_err = abs( (a-a_true)./a_true );
figure(1), plot(1:n,abs(a-a_true),'x'), title('true error')
figure(2), plot(1:n,rel_err,'x'), title('realtive error')

return
