C   A sample code to count grid points inside the
C   circle  (x-\pi)^2 + (y-sqrt(2))^2 < 1000
C   To compile (in linux/unix system): g77 count_grid.f (gnui fortran compiler),
C   or ifort count_grid.f (intel fortran compiler).
C 

        implicit none
        integer imin, imax, jmin, jmax
        parameter(imin = -30, imax = 37 ) ! (imin, imax) must cover (x0-R,x0+R)
        parameter(jmin = -30, jmax = 39 ) ! (jmin, jmax) must cover (y0-R,y0+R)
        integer  i, j, k
        real*8 x, y, x0, y0
       
        x0 = 4.*datan(1.d0)
        y0 = dsqrt(2.d0)

        k = 0
        do j = jmin, jmax
        do i = imin, imax
           x = dfloat(i)
           y = dfloat(j)
           if ( ( (x-x0)**2 + (y-y0)**2 ) .lt. 1000.d0 ) then
             k = k+1
           endif
        enddo
        enddo

        open (11,file='count_grid_result.txt')
        write(11,*) 'Number of grid points inside the circle (x-pi)^2 + 
     &(y-sqrt(2))^2 < 1000 is', k
         
        stop
        end
