N = 400;
k = 2 ;
h = pi/N;
x = 0:h:pi;            % x(i) = (i-1)h. In the notes (and convention): x_i = i*h
xm = h/2:h:pi-h/2;     % xm(i) = (i-0.5)h. In the notes and convention
                       %   x_{i+1/2} = (i+1/2)*h
f = x.*( 2 + sin(k*x) );
fm = xm.*( 2 + sin(k*xm) );
plot(x,f,x,2*x);
w = h*ones(size(xm));     % weight for midpoint rule
Ih = w*fm';               % midpoint rule for integration.
I = pi^2 + sin(pi*k)/k^2 - pi*cos(pi*k)/k;
Eh = abs( (I-Ih)/I )

