C   A sample code to evaluate Lagrange interpolating polynomials
C   using Neville's method. Algorithm 3.1 of the textbook.
C   modified for matlab reference (index starts from 1)
C   Data from section 3.1, problem 6(a).

        implicit none
        integer i,j,n
        
        real*8 R(1:10,1:10)
        real*8 x(1:10)
        real*8 xx, f
       
        n = 3
        xx = 0.43d0
        do i = 1, n+1
          read (316,*) x(i), R(i,1)
        enddo
        
        do i = 2, n+1
          do j = 2, i
            R(i,j) = ( (xx-x(i-j+1))*R(i,j-1) - (xx-x(i))*R(i-1,j-1) )
     &              /(x(i)-x(i-j+1)) 
          enddo
        enddo

        open (12,file='Neville_method_result.txt')
        write(12,*) 'Nevilles method at x =',xx, 'is', R(n+1,n+1)
        write( 6,*) 'Nevilles method at x =',xx, 'is', R(n+1,n+1)
         
        stop
        end
