C   A sample code to evaluate Lagrange interpolating polynomials
C   using Neville's method. Algorithm 3.1 of the textbook.
C   Data from section 3.1, problem 6(a).

        implicit none
        integer i,j,n
        
        real*8 Q(0:9,0:9)
        real*8 x(0:9)
        real*8 xx, f
       
        n = 3
        xx = 0.43d0
        do i = 0, n
          read (316,*) x(i), Q(i,0)
        enddo
        
        do i = 1, n
          do j = 1, i
            Q(i,j) = ( (xx-x(i-j))*Q(i,j-1) - (xx-x(i))*Q(i-1,j-1) )
     &              /(x(i)-x(i-j)) 
          enddo
        enddo

        open (12,file='Neville_method_result.txt')
        write(12,*) 'Nevilles method at x =',xx, 'is', Q(n,n)
        write( 6,*) 'Nevilles method at x =',xx, 'is', Q(n,n)
         
        stop
        end
