C   A sample code to evaluate Lagrange interpolating polynomials
C   and interpolation directly.
C   Data from section 3.1, problem 6(a).

        implicit none
        integer i,k,n
        
        real*8 L(1:10)
        real*8 x(1:10)
        real*8 y(1:10)
        real*8 xx, f
       
        n = 3
        xx = 0.43d0
        do k = 1, n+1
          read (316,*) x(k), y(k)
        enddo
        
        do k = 1, n+1
          L(k) = 1.
          do i = 1, n+1
            if ( i .ne. k ) then
              L(k) =  L(k)*(xx-x(i))/(x(k)-x(i))
            endif
          enddo
        enddo

        f = 0.
        do k = 1, n+1
          f = f + y(k)*L(k)
        enddo

        open (12,file='Lagrange_Interpolation.txt')
        write(12,*) 'Interpolated value at x =',xx, 'is', f
        write( 6,*) 'Interpolated value at x =',xx, 'is', f
         
        stop
        end
