C   A sample code to find the largest N such that
C   sum_{j=1}^N (1/j) < 5 and the corresponding sum
C 
C   To compile (in linux/unix system): g77 find_N.f (gnui fortran
C   compiler),
C   or ifort find_N.f (intel fortran compiler).
C 

        implicit none
        integer j, N
        real*8 sum
       
        j = 1
        sum = 1.d0

        do while ( sum .lt. 5.d0 ) 
          j = j+1
          sum = sum + 1.d0/dfloat(j)
        end do

        N = j-1
        sum = sum - 1.d0/dfloat(j)   
        
        open (12,file='find_N_result.txt')
        write(12,*) 'The largest N such that sum_{j=1}^N (1/j) < 5 is',
     &               N, ', and the sum is', sum
         
        stop
        end
