 function [res] = SQ(L,XX,YY,J1,J2,I,I1,I2,A,B,C)
% This function is used by Finite Element Method
% (Algorithm 12.5) to evaluate line integrals
% using Composite Simpson's Method.
 syms('X1', 'Y1', 'X2', 'Y2', 'H', 'T1', 'T2', 'T3');
 syms('K', 'X', 'Q3', 'Q1', 'Q2', 'SSQ', 'S');
 S = zeros(1,101);
 X1 = XX(J1);
 Y1 = YY(J1);
 X2 = XX(J2);
 Y2 = YY(J2);
 H = 0.01;
 T1 = X2-X1;
 T2 = Y2-Y1;
 T3 = sqrt(T1*T1+T2*T2);
 for K = 1 : 101
 X = (K-1)*H;
 if L == 1
 S(K) = T3*GG1(T1*X+X1,T2*X+Y1,A,B,C,I,I1,I2);
 end;
 if L == 2
 S(K) = T3*GG2(T1*X+X1,T2*X+Y1,A,B,C,I,I1);
 end;
 if L == 3
 S(K) = T3*GG3(T1*X+X1,T2*X+Y1,A,B,C,I,I2);
 end;
 if L == 4
 S(K) = T3*GG4(T1*X+X1,T2*X+Y1,A,B,C,I,I1);
 end;
 if L == 5
 S(K) = T3*GG5(T1*X+X1,T2*X+Y1,A,B,C,I,I2);
 end;
 end;
 Q3 = S(1)+S(101);
 Q1 = 0;
 Q2 = S(100);
 for K = 1 : 49
 Q1 = Q1+S(2*K+1);
 Q2 = Q2+S(2*K);
 end;
 SSQ = (Q3+2*Q1+4*Q2)*H/3;
 res = SSQ;

