 function [res] = SIMPSON(FN,A,B,sqq,sf,sp)
% This function is used by the Piecewise Linear Rayleigh Ritz
% Method (Algorithm 11.5) to perform Composite Simpson's Rule
 syms('H','I','Y','Z','x');
 QQ = inline(sqq,'x');
 P  = inline(sp,'x');
 F  = inline(sf,'x');
 H = (B-A)/4;
 Z = zeros(1,5);
 for I = 0 : 4
 Y = A+I*H;
 if FN == 1
 Z(I+1) = (4-I)*I*H*H*QQ(Y);
 end;
 if FN == 2
 Z(I+1) = (I*H)*(I*H)*QQ(Y);
 end;
 if FN == 3
 Z(I+1) = (H*(4-I))*(H*(4-I))*QQ(Y);
 end;
 if FN == 4
 Z(I+1) = P(Y);
 end;
 if FN == 5
 Z(I+1) = I*H*F(Y);
 end;
 if FN == 6
 Z(I+1) = (4-I)*H*F(Y);
 end;
 end;
 res = (Z(1)+Z(5)+2*Z(3)+4*(Z(2)+Z(4)))*H/3;
