function [res] = JAC(I,J,M,V,s2)
% This function is used by Newton's Method for Systems and
% by Broyden's Method (Algorithms 10.1 and 10.2) to define
% the Jacobian.
s = s2{(I-1)*M+J};
if M == 2
   g = inline(s,'y1','y2');
   res = g(V(1),V(2));
elseif M == 3
   g = inline(s,'y1','y2','y3');
   res = g(V(1),V(2),V(3));
elseif M == 4
   g = inline(s,'y1','y2','y3','y4');
   res = g(V(1),V(2),V(3),V(4));
elseif M == 5
   g = inline(s,'y1','y2','y3','y4','y5');
   res = g(V(1),V(2),V(3),V(4),V(5));
elseif M == 6
   g = inline(s,'y1','y2','y3','y4','y5','y6');
   res = g(V(1),V(2),V(3),V(4),V(5),V(6));
else
   g = inline(s,'y1','y2','y3','y4','y5','y6','y7');
   res = g(V(1),V(2),V(3),V(4),V(5),V(6),V(7));
end;




