(*
*  METHOD OF FALSE POSITION ALGORITHM 2.5	
*
*  To find a solution to f(x) = 0 given the continuous function
*  f on the interval [p0,p1], where f(p0) and f(p1) have
*  opposite signs:
*
*  INPUT: endpoints P0, P1; tolerance TOL;
*      maximum number of iterations NO.
*
*  OUTPUT: approximate solution p or a message that the
*      method fails.
*)
TEMP=Input["This is the Method of False Position.\n
Input the function F(X) in terms of x.\n
\n
For example: Cos[x]\n"];
F[x_] := Evaluate[TEMP];
OK = 0;
While[OK == 0,
   P0=Input["Endpoint p0 must be less than p1.\n
   \n
   \nInput endpoint p0"];
   P1=Input["Input endpoint p1"];
   If[P0>P1,
      X=P0;
      P0=P1;
      P1=X;
   ];
   If[P0==P1,
      Input["p0 cannot equal p1.\n
      Enter 1 [enter] to continue\n"],
      Q0 = F[P0];
      Q1 = F[P1];
      If[Q0*Q1 > 0,
         Input["F(p0) and F(p1) have the same sign.\n
         Enter 1 [enter] to continue\n"],
         OK = 1;
      ];
   ];
];
OK = 0;
While[OK == 0,
   TOL=Input["Input the tolerance\n"];
   If[TOL<=0,
      Input["Tolerance must be positive.\n
      Enter 1 [enter] to continue\n"],
      OK = 1;
   ];
];
OK = 0;
While[OK == 0,
n0 = Input["Input maximum number of iterations\n
        no decimal points\n"];
   If[n0<=0,
      Input["Must be a positive integer.\n
      Enter 1 [enter] to continue\n"],
      OK = 1
   ];
];
If[OK == 1,
   FLAG = Input["Select output destination\n
                 1. Screen\n
                 2. Text file\n
                 Enter 1 or 2\n"];
   If[FLAG == 2,
      NAME = InputString["Input the file name\n
                    For example:   output.dta\n"];
      OUP = OpenWrite[NAME,FormatType->OutputForm],
      OUP = "stdout"
   ];
   FLAG = Input["Select amount of output.\n
       Enter '1' for answer only\n
       Enter '2' for all intermediate approximations\n"];
   Write[OUP,"METHOD OF FALSE POSITION OR REGULA FALSII\n"];
   If[FLAG == 2,
      Print["\n"];
      Write[OUP," i      P        F(P)\n"],
   ];
(*STEP 1*)
   i=2;
   Q0=F[P0];
   Q1=F[P1];
   OK=1;
(*STEP 2*)
   While[i<=n0 && OK==1,
(*STEP 3, Compute P(i)*)
      P=N[P1-Q1*(P1-P0)/(Q1-Q0)];
      Q=F[P];
      If[FLAG == 2,
         Write[OUP,"\n"," ",i,"  ",P,"  ",Q] 
      ];
(*STEP 4*)
      If[Abs[P-P1]<TOL,
(*Procedure completed successfully*)
         Print["\n"];
         Write[OUP,"Approximate solution P = \n",P];
         Write[OUP,"with F(P) = \n",Q];
         Write[OUP,"Number of iterations = \n",i];   
         Write[OUP,"Tolerance = \n",TOL];
         OK=0,
(*STEP 5*)
         i = i+1;
(*STEP 6, Compute P0(i) and P1(i)*)
         If[Q*Q1<0,
            P0=P1;
            Q0=Q1;
         ];
(*STEP 7*)
         P1=P;
         Q1=Q;
      ];
   ];
   If[OK == 1,
(*Procedure completed unsuccessfully*)
      Print["\n"];
      Write[OUP,"Iteration number ",n0];
      Write[OUP,"gave approximation \n",P];
      Write[OUP,"with F(P) = \n",Q];
      Write[OUP,"not within tolerance \n",TOL]
   ];
   If[OUP == "OutputStream[",NAME," 3]",
      Print["Output file: ",NAME," created successfully\n"];
      Close[OUP];
   ];
];
