(*CHEBYSHEV RATIONAL APPROXIMATION ALGORITHM 8.2
*
*  To obtain the rational approximation
*    rT(x) = (p0*T0 + p1*T1 + ... + Pn*Tn)/(q0*T0 + q1*T1 + ... + qm*Tm)
*   for a given function f(x):
*
*   INPUT: nonnegative integers m and n.
* 
*  OUTPUT: coefficients qo, q1, ... , qm, p0, p1, ... , pn.
*
*  The coefficients of the Chebyshev expansion a0, a1, ... could
*   be calculated instead of input as is assumed in this program.
*)
OK = 0;
While[OK == 0,
   LM = Input["This is Chebysnev Approximation.\n
   \n
   Input m\n"];
   LN = Input["Input n\n"];
   BN = LM+LN;
   If[LM >= 0 && LN >= 0,
      OK = 1,
      Input["m and n must both be nonnegative\n
      \n
      Press 1 [enter] to continue\n"];
   ];
   If[LM == 0 && LN == 0,
      OK = 0;
      Input["Not both m and n cannot be zero\n
      \n
      Press 1 [enter] to continue\n"];
   ];
];
OK = 0;
While[OK == 0,
   FLAG = Input["The Chebyshev coefficients a[0], a[1], ... a[n]\n
   are to be input.\n
   Choice of input method:\n
   1. Input entry by entry from keyboard\n
   2. Input data from a text file\n
   Choose 1 or 2 please\n"];
   If[FLAG == 1 || FLAG == 2,
      OK = 1;
   ];
];
If[FLAG == 1,
   For[i = 0,i <= BN+LM,i++,
      AA[i] = Input["Please input A["<>ToString[i]<>"]\n"];
   ];
];
If[FLAG == 2,
   AAA = InputString["As many entries as desired can be placed\n
   on each line of the file separated by a blank.\n
   \n
   Has such a text file been created?\n
   Enter 'yes' or 'no'\n"];
   If[AAA=="Y" || AAA=="y" || AAA=="yes" || AAA=="YES",
      NAME = InputString["Input the file name in the form -\n
      drive:\\name.ext\n
      For example:   A:\\alg082.DTA\n"];
      INP = OpenRead[NAME];
      For[i = 0,i <= BN+LM,i++,
         AA[i] = Read[INP,Number];
      ];
      Close[INP],
      Input["Please create the input file.\n
      This program will end so the input file can\n
      be created.\n
      \n
      Press 1 [enter] to continue\n"];
      OK = 0;
   ];
];
If[OK == 1,
   (* Step 1 *)
   n = BN;
   M = n+1;
   (* Step 2 - Performed in input *)
   For[i = 0,i <= n,i++,
      NROW[i] = i;
   ];
   (* initialize row pointer *)
   NN = n-1;
   (* Step 3 *)
   q[0] = 1.0;
   (* Step 4 - Set up linear system with matrix A instead of B *)
   For[i = 0,i <= n,i++,
      (* Step 5 *)
      For[J = 0,J <= i,J++,
   	 If[J <= LN,
	    A[i,J] = 0;
	 ];
      ];
      (* Step 6 *)
      If[i <= LN,
         A[i,i] = 1.0;
      ];
      (* Step 7 *)
      For[J = i+1,J <= LN,J++,
 	 A[i,J] = 0;
      ];
      (* Step 8 *)
      For[J = LN+1,J <= n,J++,
	 If[i != 0,
	    PP = i-J+LN;
	    If[PP < 0,
	       PP = -PP;
	    ];
	    A[i,J] = -(AA[i+J-LN]+AA[PP])/2.0,
	    A[i,J] = -AA[J-LN]/2.0;
         ];
      ];
      A[i,n+1] = AA[i];
   ];
   (* Step 9 *)
   A[0,n+1] = A[0,n+1]/2.0;
   (* Steps 10-21 - Solve the linear system using partial pivoting *)
   i = LN+1;
   (* Step 10 *)
   While[OK == 1 && i <= NN,
      (* Step 11 *)
      IMAX = NROW[i];
      AMAX = Abs[A[IMAX,i]];
      IMAX = i;
      JJ = i+1;
      For[IP = JJ,IP <= n,IP++,
	 JP = NROW[IP];
	 If[Abs[A[JP,i]] > AMAX,
	    AMAX = Abs[A[JP,i]];
	    IMAX = IP;
  	 ];
      ];
      (* Step 12 *)
      If[AMAX <= 10^-20,
	 OK = 0,
         (* Step 13 - Simulate row interchange *)
	 If[NROW[i] != NROW[IMAX],
	    NCOPY = NROW[i];
	    NROW[i] = NROW[IMAX];
	    NROW[IMAX] = NCOPY;
	 ];
	 I1 = NROW[i];
         (* Step 14 - Perform elimination *)
	 For[J = JJ,J <= M,J++,
	    J1 = NROW[J];
            (* Step 15 *)
	    XM = A[J1,i]/A[I1,i];
            (* Step 16 *)
	    For[K = JJ,K <= M,K++,
	       A[J1,K] = A[J1,K]-XM*A[I1,K];
	    ];
            (* Step 17 *)
	    A[J1,i] = 0;
	 ];
      ];
      i = i+1;
   ];
   If[OK == 1,
      (* Step 18 *)
      N1 = NROW[n];
      If[Abs[A[N1,n]] <= 10^-20,
	 OK = 0,
         (* System has no unique solution *)
         (* Step 19 - Start backward substitution *)
	 If[LM > 0,
	    q[LM] = A[N1,M]/A[N1,n];
	    A[N1,M] = q[LM];
	 ];
	 PP = 1;
         (* Step 20 *)
	 For[K = LN+1,K <= NN,K++,
	    i = NN-K+LN+1;
	    JJ = i+1;
	    N2 = NROW[i];
	    SUM = A[N2,n+1];
	    For[KK = JJ,KK <= n,KK++,
	       LL = NROW[KK];
	       SUM = SUM-A[N2,KK]*A[LL,M];
	    ];
	    A[N2,M] = SUM/A[N2,i];
	    q[LM-PP] = A[N2,M];
	    PP = PP+1;
	 ];
         (* Step 21 *)
   	 For[K = 0,K <= LN,K++,
	    i = LN-K;
	    N2 = NROW[i];
	    SUM = A[N2,n+1];
	    For[KK = LN+1,KK <= n,KK++,
	       LL = NROW[KK];
	       SUM = SUM-A[N2,KK]*A[LL,M];
	    ];
	    A[N2,M] = SUM;
	    P[LN-K] = A[N2,M];
	 ];
         (* Step 22 - Procedure completed successfully *)
	 FLAG = Input["Select output destination\n
                 1. Screen\n
                 2. Text file\n
                 Enter 1 or 2\n"];
         If[FLAG == 2,
            NAME = InputString["Input the file name\n
                    For example:   output.dta\n"];
            OUP = OpenWrite[NAME,FormatType->OutputForm],
            OUP = "stdout"
         ];
	 Write[OUP,"CHEBYSHEV RATIONAL APPROXIMATION\n"];
	 Write[OUP,"\n"];
	 Write[OUP,"Denominator coefficients Q[0], ..., Q[M]\n"];
	 For[i = 0,i <= LM,i++,
	    Write[OUP,N[q[i],9]];
	 ];
	 Write[OUP,"\n"];
	 Write[OUP,"Numerator coefficients P[0], ..., P[n]\n"];
	 For[i = 0,i <= LN,i++,
	    Write[OUP,N[P[i],9]];
	 ];
         Write[OUP,"\n"];
         If[OUP == "OutputStream[",NAME," 3]",
            Print["Output file: ",NAME," created successfully\n"];
            Close[OUP];
         ];
      ];
   ];
   If[OK == 0,
      Print["System has no unique solution\n"];
   ];
];
