(*
*  STEFFENSEN'S ALGORITHM 2.6
*
*  To find a solution to g(x) = x given an 
*  initial approximation P0:
*
*  INPUT: initial approximation P0; tolerance TOL;
*      maximum number of iterations NO.
*
*  OUTPUT: approximate solution p or a message that the
*      method fails.
*)
TEMP=Input["This is Steffensen's Method.\n
Input the function G(X) in terms of x.\n
\n
For example: Cos[x]\n"];
G[x_] := Evaluate[TEMP];
P0=Input["Input initial approximation"];
OK = 0;
While[OK == 0,
   TOL=Input["Input the tolerance\n"];
      If[TOL<=0,
         Input["Tolerance must be positive.\n
            Enter 1 [enter] to continue\n"],
      OK = 1;
   ];
];
OK = 0;
While[OK == 0,
   NO = Input["Input maximum number of iterations\n
        no decimal points\n"];
   If[NO<=0,
      Input["Must be a positive integer.\n
      Enter 1 [enter] to continue\n"],
   OK = 1;
   ];
];
If[OK == 1,
   FLAG = Input["Select output destination\n
                 1. Screen\n
                 2. Text file\n
                 Enter 1 or 2\n"];
   If[FLAG == 2,
      NAME = InputString["Input the file name\n
                    For example:   output.dta\n"];
      OUP = OpenWrite[NAME,FormatType->OutputForm],
      OUP = "stdout";
   ];
   Write[OUP,"Steffensen's Method\n"];
   FLAG = Input["Select amount of output.\n
       Enter '1' for answer only\n
       Enter '2' for all intermediate approximations\n"];
   If[FLAG == 2,
      Write[OUP," i      P \n"];
   ];
(* Step 1  *)
   i=1;
   OK=1;
(* Step 2  *)
   While[i<=NO && OK==1,
(* Step 3  *)
      P1=N[G[P0]];
      P2=N[G[P1]];
      If[Abs[P2-2*P1+P0]< 10^-20,
         FLAG=1;
         dd=10;
         Write[OUP,"Denominator = 0:\n"];
         Write[OUP,"Best possible is P2  =  \n",i,
                N[P2,10]];
         OK = 0,
         dd=(P1-P0)*(P1-P0)/(P2-2*P1+P0);
      ];
      P=P0-dd;    
      If[FLAG == 2,
         Write[OUP,"\n",i,"  ",N[P,10]];
      ];
(* Step 4  *)
      If[Abs[dd]<TOL,
         Write[OUP,"Approximate solution = \n",N[P,10]];
         Write[OUP,"Number of iterations = \n",i];
         Write[OUP,"Tolerance = \n",TOL];
         OK = 0,
(* Step 5  *)
         i=i+1;
(* Step 6  *)
         P0=P;
      ];    
   ];
   If[OK == 1,
(* Step 7  *)
      Write[OUP,"Iteration number\n",NO];
      Write[OUP,"gave approximation \n",N[P,10]];
      Write[OUP,"not within tolerance \n",TOL];
      ];
   If[OUP == "OutputStream[",NAME," 3]",
      Print["Output file: ",NAME," created successfully\n"];
      Close[OUP];
   ];
];
