(*
*  SECANT ALGORITHM 2.4
*
*  To find a solution to the equation f(x) = 0 
*  given initial approximations P0 and p1:
*
*  INPUT: initial approximation P0, P1; tolerance TOL;
*      maximum number of iterations NO.
*
*  OUTPUT: approximate solution p or a message that the
*      method fails.
*)
TEMP = Input["This is the Secant Method.\n
            Input the function F(X) in terms of x.\n\n
            For example: Cos[x]\n"];
F[x_] := Evaluate[TEMP];
OK = 0;
While[OK == 0,
   P0 = Input["Input initial approximation of p0"];
   P1 = Input["Input initial approximation of p1"];
   If[P0 == P1,
      Input["p0 cannot equal p1.\n
      Enter 1 [enter] to continue\n"],
      OK = 1;
   ];
];
OK = 0;
While[OK == 0,
   TOL = Input["Input the tolerance\n"];
   If[TOL <= 0,
      Input["Tolerance must be positive.\n
             Enter 1 [enter] to continue\n"],
      OK = 1;
   ];
];
OK = 0;
While[OK == 0,
   N0 = Input["Input maximum number of iterations\n
        no decimal points\n"];
   If[N0 <= 0,
      Input["Must be a positive integer.\n
             Enter 1 [enter] to continue\n"],
      OK = 1;
   ];
];
If[OK == 1,
   FLAG = Input["Select output destination\n
                 1. Screen\n
                 2. Text file\n
                 Enter 1 or 2\n"];
   If[FLAG == 2,
      NAME = InputString["Input the file name\n
                          For example:   output.dta\n"];
      OUP = OpenWrite[NAME,FormatType->OutputForm],
      OUP = "stdout"];
   Write[OUP,"Secant Method\n"];
   FLAG = Input["Select amount of output.\n
                 Enter '1' for answer only\n
                 Enter '2' for all intermediate approximations\n"];
   If[FLAG == 2,
      Write[OUP,"i      P         F(P)\n"]];
(*STEP 1*)
i = 2;
F0 = F[P0];
F1 = F[P1];
OK = 1;
(*STEP 2*)
While[i <= N0 && OK==1,
(*STEP 3, Compute P(i)*)
   P = N[P1-(F1*(P1-P0))/(F1-F0)];
(*STEP 4*)
   FP = F[P];
   If[FLAG == 2,
      Write[OUP,i,"   ",P,"    ",FP];
   ];
   If[Abs[P-P1]<TOL,
(*Procedure completed successfully*)
      Write[OUP,"\n"];
      Write[OUP,"Approximate solution P = \n",P];
      Write[OUP,"with F(P) =\n",FP];
      Write[OUP,"Number of iterations = \n",i];
      Write[OUP,"Tolerance = \n",TOL];
      OK = 0,
(*STEP 5*)
      i = i+1;
(*STEP 6, update P0,F0,P1,F1*)
      P0 = P1;
      F0 = F1;
      P1 = P;
      F1 = FP;
   ];
];
If[OK == 1,
(*STEP 7*)
   Write[OUP,"Iteration number \n",N0];
   Write[OUP,"gave approximation \n",P];
   Write[OUP,"with F(P) = ",FP,"  not within tolerance \n",TOL];
];
If[OUP == "OutputStream[",NAME," 3]",
   Print["Output file: ",NAME," created successfully\n"];
   Close[OUP]];
]
