(*
*  FIXED-POINT ALGORITHM 2.2
*
*  To find a solution to p = g(p) given an 
*  initial approximation p0
*
*  INPUT: initial approximation; tolerance TOL;
*      maximum number of iterations NO.
*
*  OUTPUT: approximate solution p or a message that the
*      method fails.
*)
TEMP = Input["This is the Fixed-Point Method.\n
              Input the function G(X) in terms of x.\n\n
              For example: Cos[x]\n"];
G[x_] := Evaluate[TEMP];
P0 = Input["Input initial approximation"];
OK = 0;
While[OK == 0,
   TOL = Input["Input the tolerance\n"];
   If[TOL<=0,
      Input["Tolerance must be positive.\n
             Enter 1 [enter] to continue\n"],
      OK = 1;
   ];
];
OK = 0;
While[OK == 0,
   NO = Input["Input maximum number of iterations\n
               no decimal points\n"];
   If[NO <= 0,
      Input["Must be a positive integer.\n
             Enter 1 [enter] to continue\n"],
      OK = 1;
   ]
]
If[OK == 1,
   FLAG = Input["Select output destination\n
                 1. Screen\n
                 2. Text file\n
                 Enter 1 or 2\n"];
   If[FLAG == 2,
      NAME = InputString["Input the file name\n
                    For example:   output.dta\n"];
      OUP = OpenWrite[NAME,FormatType->OutputForm],
      OUP = "stdout";
   ];
   FLAG = Input["Select amount of output.\n
                 Enter '1' for answer only\n
                 Enter '2' for all intermediate approximations\n"];
   Write[OUP,"Fixed-Point Method\n"];
   If[FLAG == 2,
      Write[OUP,"i         P\n"],
   ];
(* Step 1  *)
   i = 1;
   OK = 1;
(* Step 2  *)
   While[i <= NO && OK == 1,
(* Step 3  *)
      P = N[G[P0]];
      If[FLAG == 2,
         Write[OUP,"",i,"      ",N[P,10]]
      ];
(* Step 4  *)
      If[Abs[P-P0] < TOL,
         Write[OUP,"Approximate solution P = \n",N[P,10]];
         Write[OUP,"Number of iterations = \n",i];   
         Write[OUP,"Tolerance = \n",TOL];
         OK = 0,
(* Step 5  *)
         i = i+1;
(* Step 6  *)
         P0 = P;
      ];
   ];
   If[OK == 1,
(* Step 7  *)
      Write[OUP,"Iteration number ",NO];
      Write[OUP,"gave approximation \n",N[P,10]];
      Write[OUP,"not within tolerance \n",TOL]
   ];
   If[OUP == "OutputStream[",NAME," 3]",
   Print["Output file: ",NAME," created successfully\n"];
   Close[OUP]
   ];
]
