(*
*  HORNER'S ALGORITHM 2.7
*
*  To evaluate the polynomial
*  p(x) = a(n)*x^n + a(n-1)*x^(n-1) + ... + a(1)*x + a(0) 
*  and its derivative p'(x) at x = x0;
*
*  INPUT: degree n; coefficients aa(0), aa(1), ... , aa(n);
*      value of x0.
*
*  OUTPUT: y = p(x0), z = p'(x0).
*)
OK = 0;
While[OK == 0,
   n=Input["This is Horner's Method\n\n
   Input degree n of polynomial - no decimal point\n"];   
   If[n < 0,
      Input["Incorrect input - degree must be positive.\n
           Enter 1 [enter] to continue\n"],
      OK = 1;
   ];
];
Input["Input coefficients of P(x) in ascending order\n
    Press 1 [enter] to continue\n "];
For[i = 0,
    i <= n,
    i++,
    AA[i]=Input["Input the coefficient of x^("<>ToString[i]<>")\n"];
];
X0 = Input["Input argument X0 at which to evaluate P(x)\n"];
(*STEP 1, Compute b(n) for p(x)*)
Y = AA[n];
(*Compute b(n-1) for q(x)=p'(x)*)
If[n == 0,
   Z = 0,
   Z = AA[n];
];
MM = n-1;
(*STEP 2*)
For[i = 1,
   i <= MM,
   i++,
   J = n-i;
(*compute b(j) for p(x)*)
   Y = Y*X0+AA[J];
(*compute b(j-1) for q(x)*)
   Z = Z*X0+Y;
];
(*STEP 3, compute b(0) for p(x)*)
If[n != 0,
   Y = Y*X0+AA[0];
];
Print["\nCoefficients of polynomial P:\n"];
(*STEP 4*)
For[ i= 0,
   i <= n,
   i++,
   Print["Exponent = ",i,"     Coefficient = ",AA[i]];
];
Print["\n"];
Print["P(",X0,")= ",Y];
Print["P'(",X0,")= ",Z];
