import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class Wiel
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField nDegree, matAField, matXField, matVField, xmuField, tolField, iteratn;
  private JTextArea solution;
  private int NUM, N, M, I, J, K, I1, N1, I2, L1, L2, NN; 
  private boolean OK, inputCancel;
  private NumberFormat formatter;
  private double A[][], B[][], V[], VV[], W[], X[], Y[];
  private double YMU, XMU, ERR, TOL, S, AMAX;
  

  public void init() {
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[10][10]; B = new double[10][10];
                X = new double[10]; Y = new double[10];
                V = new double[10]; VV = new double[10]; W = new double[10];
                N = Integer.parseInt(nDegree.getText());
                NN = Integer.parseInt(iteratn.getText());
                TOL = Double.parseDouble(tolField.getText());
                XMU = Double.parseDouble(xmuField.getText());
                 M = N - 1;
                OK = true;  inputCancel = false;
                arrayInput(A, matAField.getText());
                toArray(matXField.getText(), X);
                toArray(matVField.getText(), V);
                solution.setText("");

           if(inputCheck())
             {
            solution.setText("");       
            solution.append("The Wielandt Method\n\n");

      /* STEP 1 */
      I = 1;
      AMAX = Math.abs(V[0]);
      for (J=2; J<=N; J++) {
         if (Math.abs(V[J-1]) > AMAX) {
            I = J;
            AMAX = Math.abs(V[J-1]);

         }  
      }  
      /* STEP 2 */
      if (I != 1) {
         for (K=1; K<=I-1; K++)
            for (J=1; J<=I-1; J++) 
               B[K-1][J-1] = A[K-1][J-1] - V[K-1] * A[I-1][J-1] / V[I-1];
      }        
      /* STEP 3 */
      if ((I != 1) && (I != N)) {
         for (K=I; K<=N-1; K++)
            for (J=1; J<=I-1; J++) {
               B[K-1][J-1] = A[K][J-1]-V[K]*A[I-1][J-1]/V[I-1];
               B[J-1][K-1] = A[J-1][K]-V[J-1]*A[I-1][K]/V[I-1];
            }  
      }     
      /* STEP 4 */
      if (I != N) {
         for (K=I; K<=N-1; K++)
            for (J=I; J<=N-1; J++)
               B[K-1][J-1] = A[K][J]-V[K]*A[I-1][J]/V[I-1];
      }        
      /* STEP 5 */
      POWER(); //X, M, OK, Y, B, YMU, TOL, NN
      if (OK) {
         /* STEP 6 */
         if (I != 1)
            for (K=1; K<=I-1; K++) W[K-1] = Y[K-1];
         /* STEP 7 */
         W[I-1] = 0.0;
         /* STEP 8 */
         if (I != N)
            for (K=I+1; K<=N; K++) W[K-1] = Y[K - 2]; 
         /* STEP 9 */
         S = 0.0;
         for (J=1; J<=N; J++) S = S + A[I-1][J-1] * W[J-1];
         S = S / V[I-1];
         for (K=1; K<=N; K++) 
            /* Compute eigenvector
               VV is used in place of U here */
            VV[K-1] = (YMU - XMU) * W[K-1] + S * V[K-1];
         solution.append("\nThe reduced matrix B:\n");
         for (L1=1; L1<=M; L1++) {
            for (L2=1; L2<=M; L2++) solution.append(""+formatter.format(B[L1-1][L2-1])+"\t");
            solution.append( "\n");
         }  
         solution.append( "\nThe Eigenvalue = "+ formatter.format(YMU));
         solution.append( " to Tolerance = "+ TOL+"\n");
         solution.append( "Eigenvector is:\n");
         for (I=1; I<=N; I++) solution.append(" "+ formatter.format(VV[I-1])+"   ");
         solution.append( "\n");
      
      }
    }
}


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }

//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************

  public void POWER() //double X[], int M, boolean OK, double Y[], double B[][], double YMU,  double TOL, int NN
   {
   double AMAX,T,ERR;
   int K,LP,I,J;
   boolean DONE;
   
   K=1;
   LP=1;
   AMAX = Math.abs(X[0]);
   for (I=2; I<=M; I++)
      if (Math.abs(X[I-1]) > AMAX) {
         AMAX = Math.abs(X[I-1]);
         LP = I;
      }  
   DONE = false;
   for (I=1; I<=M; I++) X[I-1] = X[I-1] / AMAX;
   while ((K <= NN) && OK && !DONE) {
      for (I=1; I<=M; I++) {
         Y[I-1] = 0.0;
         for (J=1; J<=M; J++) Y[I-1] = Y[I-1] + B[I-1][J-1] * X[J-1];
      }

       YMU = Y[LP-1];
       LP = 1;
       AMAX = Math.abs(Y[0]);
       for (I=2; I<=M; I++) {
         if (Math.abs(Y[I-1]) > AMAX) {
            AMAX = Math.abs(Y[I-1]);
            LP = I;
         }  
      }  

      if (AMAX <= 0) {
         solution.append("Zero eigenvalue - B is singular\n");
         OK = false;
      }  
      else {
         ERR = 0.0;
         for (I=1; I<=M; I++) {
            T = Y[I-1] / Y[LP-1];
            if (Math.abs(X[I-1] - T) > ERR)
               ERR = Math.abs(X[I-1] - T);
            X[I-1] = T;
         }  
         if (ERR < TOL) {
            for (I=1; I<=M; I++) Y[I-1] = X[I-1];
            DONE = true;
         }  
         else K++;
      }  
   }
   if ((K > NN) && OK) {
      solution.append("Power Method did not converge in "+NN+" iterations.\n");
      OK = false;
   }  
   else
      solution.append("Number Iterations for Power Method = "+ K +"\n");
}

  

  public void arrayInput(double arr[][], String str){

     try{
 
      String[] charArray = StringtoArray(str,",");
     if(N>0){ 
      if(N>(charArray.length/N)) {
//         solution.append("Dimension is greater than matrix entered\n");
         inputCancel = true; 
         }
       else{
      for(int i = 0; i< N; i++){
  
        for(int j=0;j < N; ++j)
             arr[i][j] = Double.parseDouble(charArray[N*i +j]);
       }
      }
     }
    }
   catch(NumberFormatException ex){ inputCancel= true; }       
  }

  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i= 0; i< charArray.length; i++)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }


  public boolean inputCheck()
   {
   
          if (N <= 1 ){
            solution.append("Dimension must be grater than 1\n");
          OK = false;}
          if (NN <= 0 ){
            solution.append("Number of Iterations must be a positive integer. \n");
          OK = false;}

          if (TOL <= 0 ){
            solution.append("Tolerance must be a positive number. \n");
         OK = false;}

          for(I = 0; I < N; I++){ if(V[I] == 0){
            solution.append("All vectors must be nonzero.\n");
         OK = false;}}

          for(I = 0; I < N-1; I++){ if(X[I] == 0){
            solution.append("All vectors must be nonzero.\n");
         OK = false;}}

        if (inputCancel){
            solution.append("Dimension is greater than matrix entered\n");
            solution.append("Values must be entered for matrix. \n");
            inputCancel = false;
          OK = false;}
          return OK;

   }   
 


   public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    tolField = new JTextField(2);
    xmuField = new JTextField(2);
    iteratn = new JTextField(2);
    matAField = new JTextField(40);
    matXField = new JTextField(40);
    matVField = new JTextField(40);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(4,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Dimension n =:", JLabel.RIGHT));
    inputPanel.add(nDegree);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Iterations  =:", JLabel.RIGHT));
    inputPanel.add(iteratn);
    inputPanel.add(new JLabel("Tolerance  =:", JLabel.RIGHT));
    inputPanel.add(tolField);

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Eigenvalue  =:", JLabel.RIGHT));
    inputPanel.add(xmuField);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    JPanel inputPanel2 = new JPanel(new GridLayout(4,2));

    inputPanel2.add(new JLabel("A(i,j) in row form. Separate elements with commas \",\" A =:", JLabel.RIGHT));
    inputPanel2.add(matAField); matAField.setText("-4,-1,1,-1,3,-2,1,-2,3");

    inputPanel2.add(new JLabel("V(i), approx eigenvector. Separate elements with commas \",\" V =:", JLabel.RIGHT));
    inputPanel2.add(matVField); matVField.setText("1,-1,1");

    inputPanel2.add(new JLabel("X(i), eigenvector. Separate elements with commas \",\" X =:", JLabel.RIGHT));
    inputPanel2.add(matXField); matXField.setText("2,1");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
