
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class WaveE
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField pointFX, maxFT, alphaCon, intN, intM, exprField, exprField2;
  private JTextArea solution;
  private double W[][],FT, FX, ALPHA, H, K, V, X;
  private int N, M, M1, M2, N1, N2, I, J;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 W = new double[51][51] ;
                 FX = Double.parseDouble(pointFX.getText());
                 FT = Double.parseDouble(maxFT.getText());
                 ALPHA = Double.parseDouble(alphaCon.getText());
                 M = Integer.parseInt(intM.getText());
                 N = Integer.parseInt(intN.getText());
                 OK  = true; 
            solution.setText("");             

            if(inputCheck()){
            solution.setText("");             
      M1 = M + 1;
      M2 = M - 1;
      N1 = N + 1;
      N2 = N - 1;
      /* STEP 1 */
      /* V is used for lambda */
      H = FX / M;
      K = FT / N;
      V = ALPHA * K / H;
      /* STEP 2 */
      for (J=2; J<=N1; J++) {
         W[0][J-1] = 0.0;
         W[M1-1][J-1] = 0.0;
      }  
      /* STEP 3 */
      W[0][0] = functnF( 0.0 );
      W[M1-1][0] = functnF ( FX );
      /* STEP 4 */
      for (I=2; I<=M; I++) {
         W[I-1][0] = functnF( H * ( I - 1.0 ) );
         W[I-1][1] = (1.0-V*V)*functnF(H*(I-1.0))+V*V*(functnF(I*H)+
                     functnF(H*(I-2.0)))/2.0+K*functnG(H*(I-1.0));
      }  
      /* STEP 5 */ 
      for (J=2; J<=N; J++) 
         for (I=2; I<=M; I++) 
            W[I-1][J] = 2.0*(1.0-V*V)*W[I-1][J-1]+V*V*
                        (W[I][J-1]+W[I-2][J-1])-W[I-1][J-2];
      /* STEP 6 */
        OUTPUT();
               }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


   public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
		myParser.parseExpression(exp);
	}


  public double functnF(double point)
   {
    double f;
    xValue = point;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }

    public double functnG(double point)
   {
    double g;
    xValue = point;  
    parseExp(exprField2.getText());
    g = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return g;
   }

  public boolean inputCheck()
   {
        String errorInfo;
          if (FX <= 0 ){
            solution.append("Righthand endpoint must be positive.\n");
            OK = false;}
          if (FT <= 0 ){
            solution.append("Maximum value of the time variable T must be positive.\n");
            OK = false;}

          if ((N <= 0 )||(M<=2)){
            solution.append("M and N must be positive and M must be greater than 2\n");
            OK = false;}

            parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
            parseExp(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          return OK;
   }     

  public void OUTPUT()
   {
     solution.append("Wave Equation Finite-Difference\n\n");             
     solution.append("I\tX(I)\tW(X(I),"+FT+")\n");             
     for(I=1; I<=M1; I++){
        X = (I - 1)* H;
        solution.append(" "+I+"\t"+formatter.format(X)+"\t"+formatter.format(W[I-1][N1-1])+"\n");         }
    }
 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    pointFX = new JTextField(4);
    maxFT = new JTextField(4);
    intM = new JTextField(4);
    intN = new JTextField(4);
    alphaCon = new JTextField(4);
    exprField = new JTextField(20);
    exprField2 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function f(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("sin(pi*x)");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function g(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("0.0");
    inputPanel.add(new JLabel("endPoint l :", JLabel.RIGHT));
    inputPanel.add(pointFX);pointFX.setText("1");
    inputPanel.add(new JLabel("ALPHA =:", JLabel.RIGHT));
    inputPanel.add(alphaCon);alphaCon.setText("2");

    inputPanel.add(new JLabel("intervals M:", JLabel.RIGHT));
    inputPanel.add(intM);intM.setText("10");
    inputPanel.add(new JLabel("intervals N:", JLabel.RIGHT));
    inputPanel.add(intN);intN.setText("20");
    inputPanel.add(new JLabel("max time var T:", JLabel.RIGHT));
    inputPanel.add(maxFT);maxFT.setText("1");


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
