
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Trapez
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, AlphaCondn, integerN, maxM, Tolerance, exprField, exprField2;
  private JTextArea solution;
  private double A, B, Tol, Alpha, H, T, W, W0, Y, XK1;
  private int I, J, K, P, N, M, IFlag;
  private boolean OK;
  private NumberFormat formatter;
  private double yValue, tValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 N = Integer.parseInt(integerN.getText());
                 M = Integer.parseInt(maxM.getText());
                 Alpha = Double.parseDouble(AlphaCondn.getText());
                 Tol = Double.parseDouble(Tolerance.getText());


                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
                solution.append(" "+" T\tW\tJ\n");
      /* STEP 1 */
      W = Alpha;
      T = A;
      H = (B - A) / N;
solution.append(" "+formatter.format(T)+"\t"+formatter.format(W)+"\n");
      I = 1;
      OK = true;
      /* STEP 2 */
      while ((I <= N) && OK) {
         /* STEP 3 */ 
         XK1 = W + 0.5 * H * functnF(T, W);
         W0 = XK1;
         J = 1;
         IFlag = 0;
         /* STEP 4 */
         while ((IFlag == 0) && OK) {
            /* STEP 5 */
            W = W0 - (W0 - XK1 - 0.5 * H * functnF(T + H, W0)) /
                (1.0 - 0.5 * H * functnFYP( T + H, W0));
            /* STEP 6 */
            if (Math.abs(W-W0) < Tol) {
               IFlag = 1;
               /* STEP 7 */
               T = A + I * H;
solution.append(" "+formatter.format(T)+"\t"+formatter.format(W)+"\t"+formatter.format(J)+"\n"); 
               I++;
            }  
            else {
               J++;
               W0 = W;
               if (J > M) OK = false;    
            }   
         }  
      }
      if (!OK) solution.append("Maximum Number of Iterations Exceeded\n");
      /* STEP 8 */
 
                   
          }
        }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
              
 

     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("t", tValue);
		myParser.addVariable("y", yValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2)
   {
    double f;
    tValue = point1;
    yValue = point2;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
  public double functnFYP(double point1, double point2)
   {
    double f;
    tValue = point1;
    yValue = point2;  
    parseExp(exprField2.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }

    public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (Tol <=0){
            solution.append("Tolerance must be positive \n");
            OK = false;}

          if (N <= 0){
            solution.append("Input a positive number for the number of subintervals\n");
            OK = false;}

          if (M <=0) {
            solution.append("The number of iterations must be positive\n");
            OK = false;}


          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     
 

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    AlphaCondn = new JTextField(4);
    maxM = new JTextField(2);
    integerN = new JTextField(2);
    Tolerance = new JTextField(4);
    exprField = new JTextField(20);
    exprField2 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function f(t,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("5*e^(5*t)*(y - t)^2 + 1");
    inputPanel.add(new JLabel("Function fyp(t,y)=:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("10*e^(5*t)*(y - t)");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("Condition Alpha =:", JLabel.RIGHT));
    inputPanel.add(AlphaCondn);


    inputPanel.add(new JLabel("M =:", JLabel.RIGHT));
    inputPanel.add(maxM);
    inputPanel.add(new JLabel("N =:", JLabel.RIGHT));
    inputPanel.add(integerN);
    inputPanel.add(new JLabel("Tolerance =:", JLabel.RIGHT));
    inputPanel.add(Tolerance);

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
