
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Steff
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField initPoint, tTolerance, nIteration, exprField;
  private JTextArea solution;
  private double p0, p1, p2, p, d, TOL;
  private int I, iterations;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 p0 = Double.parseDouble(initPoint.getText());
                TOL = Double.parseDouble(tTolerance.getText());
         iterations = Integer.parseInt(nIteration.getText());
                OK  = true; 
            solution.setText("");             

            if(inputCheck()){ I= 1;
            solution.append("  "+" I\tP\n ");
            solution.append("=======================\n");       
       while(I<=iterations && OK){
               p1 =functnG(p0);
               p2 =functnG(p1);
            if (absVal(p2-2*p1+p0)< 0){
               d = 10;               
               solution.append("Denominator = 0, method fails\n");
               solution.append("best possible is P2( " +I+ ") = "+p2+"\n");
               OK = false;
               } 
               else{
               d = (p1 -p0)*(p1 - p0)/(p2 - 2*p1 + p0);}
               p = p0 - d; 
            solution.append(" "+ I +"\t"+formatter.format(p)+"\n");       
            if (absVal(d)< TOL){
             solution.append("No of Iterations "+I+" \n");
             solution.append("Approximation solution "+ formatter.format(p)+" \n");
             solution.append("Tolerance "+ TOL);

               OK = false;}
            else{ 
                I++;
                p0 = p;
                }
           }
        if (OK){
          solution.append("No of Iterations "+nIteration.getText()+" \n");
          solution.append("gave approximation "+ formatter.format(p)+" \n");
          solution.append("not within tolerance "+ TOL);}
          }
        }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
   public void parseExpression() {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
		myParser.parseExpression(exprField.getText());
	}


  public double functnG(double point)
   {
    double g;
    xValue = point;  
    parseExpression();
    g = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return g;
   }
  
  public boolean inputCheck()
   {
        String errorInfo;
          if (TOL <=0.0){
            solution.append("Tolerance must be positive \n");
            OK = false;}
          if (iterations <=0 ){
            solution.append("Number of Iterations must be positive \n");
            OK = false;}
            parseExpression();
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          return OK;
   }     

 public double absVal(double val)
  { 
    if( val >= 0) return val;
    else return -val;
  }  
 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    initPoint = new JTextField(4);
    tTolerance = new JTextField(6);
    nIteration = new JTextField(2);
    exprField = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(4,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Function g =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("sqrt(10/(4+x))");
    inputPanel.add(new JLabel("Point Po:", JLabel.RIGHT));
    inputPanel.add(initPoint);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("TOL:", JLabel.RIGHT));
    inputPanel.add(tTolerance);
    inputPanel.add(new JLabel("No Iterations:", JLabel.RIGHT));
    inputPanel.add(nIteration);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }



  }
    
   
