
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Steep
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField approxX, approxY, approxZ, intNN, intN, tolerance, expr1, expr2,expr3;
  private JTextField expr4, expr5, expr6, expr7, expr8, expr9, expr10, expr11, expr12;
  private JTextArea solution;
  private double A[], G[], C[], X[], Z[]; 
  private double Z0, X0, G0, H1, H2, H3, A0, TOL;
  private int N, NN, I, K, KK, FLAG1;
  private boolean  FLAG, OK;
  private NumberFormat formatter;
  private double xValue, yValue, zValue;

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = new double[4]; X = new double[10]; C = new double[10];
                 G = new double[4]; Z = new double[10];
                 TOL = Double.parseDouble(tolerance.getText());
                 N = Integer.parseInt(intN.getText());
                 NN = Integer.parseInt(intNN.getText());
                 X[0] = Double.parseDouble(approxX.getText());
                 X[1] = Double.parseDouble(approxY.getText());
                 X[2] = Double.parseDouble(approxZ.getText());
                 OK  = true; 
                 solution.setText("");             
                 FLAG1 = 2;
                 
            if(inputCheck()){
                 solution.setText("");
                 solution.append("Steepest Decent Algorithm.\n\n");
                 if(N==3) solution.append("Iteration\tX\tY\tZ\n");             
                 else solution.append("Iteration\tX\tY\n");             
      /* STEP 1 */
      K = 1;
      /* STEP 2 */
      while (OK && (K <= NN)) {
         /* STEP 3 */
         G[0] = functnF(X);
         Z0 = 0.0;
         for (I=1; I<=N; I++) {
            Z[I-1] = functnP( I );
            Z0 = Z0 + ( Z[I-1] ) * ( Z[I-1] );
         }  
         Z0 = Math.sqrt( Z0 );
         /* STEP 4 */
         if (Z0 <= 0) {
            OK = false;
            solution.append( "0 qradient - may have a minimum\n");
         }  
         else { 
            /* STEP 5 */
            for (I=1; I<=N; I++) Z[I-1] = Z[I-1] / Z0;
            A[0] = 0.0;
            X0 = 1.0;
            for (I=1; I<=N; I++) C[I-1] = X[I-1] - X0 * Z[I-1];
            G0 = functnF(C);
            /* STEP 6 */
            FLAG = true;
            if (G0 < G[0]) FLAG = false;
            while (FLAG && OK) {
               /* STEPS 7 AND 8 */
               X0 = 0.5 * X0;
               if ( X0 <= 0 ) {
                  OK = false;
                  solution.append( "No likely improvement - may\n");
                  solution.append( "have a minimum\n");
               }  
               else {
                  for (I=1; I<=N; I++) C[I-1] = X[I-1]-X0*Z[I-1];
                  G0 = functnF(C);
               }  
               if (G0 < G[0]) FLAG = false;
            }  
            if (OK) {
               A[2] = X0;
               G[2] = G0;
               /* STEP 9 */
               X0 = 0.5 * X0;
               for (I=1; I<=N; I++) C[I-1] = X[I-1]-X0*Z[I-1];
               A[1] = X0;
               G[1] = functnF(C);
               /* STEP 10 */
               H1 = (G[1]-G[0])/(A[1]-A[0]);
               H2 = (G[2]-G[1])/(A[2]-A[1]);
               H3 = (H2-H1)/(A[2]-A[0]);
               /* STEP 11 */
               X0 = 0.5*(A[0]+A[1]-H1/H3);
               for (I=1; I<=N; I++) C[I-1] = X[I-1]-X0*Z[I-1];
               G0 = functnF(C);
               /* STEP 12 */
               A0 = X0;
               for (I=1; I<=N; I++) 
                  if (Math.abs(G[I-1]) < Math.abs(G0)) {
                     A0 = A[I-1];
                     G0 = G[I-1];
                  }  
               if (Math.abs(A0) <= 0) {
                  OK = false;
                  solution.append( "No change likely\n");
                  solution.append( "- probably rounding error problems\n");
               }  
               else {
                  /* STEP 13 */
                  for (I=1; I<=N; I++) X[I-1] = X[I-1]-A0*Z[I-1];
                  /* STEP 14 */
                  if (FLAG1 == 2) {
                    solution.append(" "+K+"\t");
                    for (I=1; I<=N; I++) solution.append(formatter.format(X[I-1])+"\t");
                    solution.append("\n");
                  }  
                  if ((Math.abs(G0) < TOL) || (Math.abs(G0-G[0]) < TOL)) {
                     OK = false;
                     solution.append( "Iteration number "+ K);
                     solution.append( " gives solution\n");
                     for (I=1; I<=N; I++) solution.append(formatter.format(X[I-1])+"\t");
                     solution.append( "\nto within "+ TOL);
                     solution.append( " Process is complete\n");
                  }  
                  else 
                     /* STEP 15 */
                     K++;
               }  
            }  
         }
      }  
      if (K > NN) {
         /* STEP 16 */
         solution.append( "Process does not converge in "+ NN+" iterations");
              }
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


    public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
		myParser.addVariable("y", yValue);
		myParser.addVariable("z", zValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnCF(int I, double X[])
   {
    double f; f = 0;
    xValue = X[0];
    yValue = X[1];  
    zValue = X[2];  
   switch (I) {
      case 1:
          parseExp(expr1.getText());
          f = myParser.getValue(); 
         break;
      case 2:
          parseExp(expr2.getText());
          f = myParser.getValue(); 
         break;
      case 3:
          parseExp(expr3.getText());
          f = myParser.getValue(); 
         break;
   }   
   return f;
}

public double functnP(int I)
{
   double p; p=0;
   if(N==3){
   switch (I) {
      case 1: 
         p =  2 * functnPD(expr4.getText()) * functnCF( 1, X )
            + 2 * functnPD(expr7.getText()) * functnCF( 2, X )
            + 2 * functnPD(expr10.getText()) * functnCF( 3, X );
         break;
      case 2:
         p =  2 * functnPD(expr5.getText()) * functnCF( 1, X )
            + 2 * functnPD(expr8.getText()) * functnCF( 2, X )
            + 2 * functnPD(expr11.getText()) * functnCF( 3, X );
          break;
      case 3:
         p =  2 * functnPD(expr6.getText()) * functnCF( 1, X )
            + 2 * functnPD(expr9.getText()) * functnCF( 2, X )
            + 2 * functnPD(expr12.getText()) * functnCF( 3, X );

         break;
     }
  }else{
   switch (I) {
      case 1: 
         p =  2 * functnPD(expr4.getText()) * functnCF( 1, X )
            + 2 * functnPD(expr7.getText()) * functnCF( 2, X );
         break;
      case 2:
         p =  2 * functnPD(expr5.getText()) * functnCF( 1, X )
            + 2 * functnPD(expr8.getText()) * functnCF( 2, X );
          break;
 
   }}
   return p;
}  

public double functnF(double X[] )  
{
   double f, D;
   int I;
   D = 0.0;
   for (I=1; I<=N; I++) D = D +  functnCF( I, X ) * functnCF( I, X );
   f = D;
   return f;
}
/*  P is the Jacobian Matrix  J(X)  */
  public double functnPD(String  expr)
   {
    double pd;
    xValue = X[0];
    yValue = X[1];  
    zValue = X[2];  
    parseExp(expr);
    pd = myParser.getValue(); 
    return pd;
   }
   

  public boolean inputCheck()
   {
        String errorInfo;
          if (NN <= 0 ){
            solution.append("Iterations must be a positive integer. \n");
            OK = false;}

          if ((N < 2) || (N >3)){
            solution.append("You can only work with 2 or 3 non linear equations. \n");
            OK = false;}

          if (TOL <= 0){
            solution.append("Tolerance must be positive. \n");
            OK = false;}
          

          parseExp(expr1.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr3.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr4.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr5.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr6.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr7.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr8.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr9.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr10.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr11.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr12.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    intN = new JTextField(4);
    intNN = new JTextField(4);
    approxX = new JTextField(4);
    approxY = new JTextField(4);
    approxZ = new JTextField(4);
    tolerance = new JTextField(6);
    expr1 = new JTextField(20);
    expr2 = new JTextField(20);
    expr3 = new JTextField(20);
    expr4 = new JTextField(20);
    expr5 = new JTextField(20);
    expr6 = new JTextField(20);
    expr7 = new JTextField(20);
    expr8 = new JTextField(20);
    expr9 = new JTextField(20);
    expr10 = new JTextField(20);
    expr11 = new JTextField(20);
    expr12 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(8,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("f1(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr1); expr1.setText("3*x -cos(y*z)-.5");
    inputPanel.add(new JLabel("f2(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr2); expr2.setText("x^2-81*(y+.1)^2+sin(z)+1.06");
    inputPanel.add(new JLabel("f3(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr3); expr3.setText("e^(-x*y) + 20*z + (10*pi-3)/3");

    inputPanel.add(new JLabel("Dx(f1(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr4); expr4.setText("3");
    inputPanel.add(new JLabel("Dy(f1(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr5); expr5.setText("z*sin(y*z)");
    inputPanel.add(new JLabel("Dz(f1(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr6); expr6.setText("y*sin(y*z)");

    inputPanel.add(new JLabel("Dx(f2(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr7); expr7.setText("2x");
    inputPanel.add(new JLabel("Dy(f2(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr8); expr8.setText("-162*(y+.1)");
    inputPanel.add(new JLabel("Dz(f2(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr9); expr9.setText("cos(z)");

    inputPanel.add(new JLabel("Dx(f3(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr10); expr10.setText("-y*e^(-x*y)");
    inputPanel.add(new JLabel("Dy(f3(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr11); expr11.setText("-x*e^(-x*y)");
    inputPanel.add(new JLabel("Dz(f3(x,y,z)) =:", JLabel.RIGHT));
    inputPanel.add(expr12); expr12.setText("20");


    inputPanel.add(new JLabel("Approx X =:", JLabel.RIGHT));
    inputPanel.add(approxX);
    inputPanel.add(new JLabel("Approx Y =:", JLabel.RIGHT));
    inputPanel.add(approxY);
    inputPanel.add(new JLabel("Approx Z =:", JLabel.RIGHT));
    inputPanel.add(approxZ);

    inputPanel.add(new JLabel("No of Equatns:", JLabel.RIGHT));
    inputPanel.add(intN);intN.setText("3");
    inputPanel.add(new JLabel("Iterations =:", JLabel.RIGHT));
    inputPanel.add(intNN);
    inputPanel.add(new JLabel(" TOL =:", JLabel.RIGHT));
    inputPanel.add(tolerance);

  
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
