
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class SDouble
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, integerM, integerN, exprField, exprField2, exprField3;
  private JTextArea solution;
  private double A, B, H, AN, AE, AO, X, HX, BN,YA, YB, BE, BO, Y, Z, A1, AC;
  private int I, J, M, N, NN, MM;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue, yValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 M = Integer.parseInt(integerM.getText());
                 N = Integer.parseInt(integerN.getText());

                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
                NN = 2*N;
                MM = 2*M - 1;
                H = (B - A) / NN;
                AN = 0;
                AE = 0;
                AO = 0;
             for(I = 0; I <=NN; I++){
                 X = A + I*H ;
                 YA= functnC(X);
                 YB= functnD(X);
                 HX = (YB - YA)/(2*M);
                 BN = functnF(X, YA) + functnF(X, YB);
                 BE = 0;
                 BO = 0;
               for(J=1; J<=MM; J++){
                  Y = YA + J*HX;
                  Z = functnF(X, Y);
                  if( (J%2) == 0) {BE = BE + Z;} else{ BO = BO + Z;}
                 }

               A1 = (BN + 2*BE + 4*BO)*HX/3;
         
                if((I == 0) || (I == NN)) {AN = AN + A1;} 
                else{
                     if((I%2)==0) {AE = AE + A1;} else{AO = AO + A1;}
                  }
                }
                AC = (AN + 2*AE + 4*AO)*H/3;

                output();
             
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
		myParser.addVariable("y", yValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2)
   {
    double f;
    xValue = point1;
    yValue = point2;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
  public double functnC(double point)
   {
    double c;
    xValue = point;
    parseExp(exprField2.getText());
    c = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return c;
   }

  public double functnD(double point)
   {
    double d;
    xValue = point;
    parseExp(exprField3.getText());
    d = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return d;
   }

 public void output()
   {
      solution.append("\n\nThe integral of F from c(x) to d(x) and "+A+" to "+B+" is "+formatter.format(AC));
      solution.append("\n obtained with M = "+M+" and N = "+N);
   }      
 

  public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if ((N <=0) || (M <=0) ){
            solution.append("M and N must be positive \n");
            OK = false;}
          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField3.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    integerM = new JTextField(2);
    integerN = new JTextField(2);
    exprField = new JTextField(20);
    exprField2 = new JTextField(20);
    exprField3 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function f(x,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("e^(y/x)");
    inputPanel.add(new JLabel("Function C(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("x^3");
    inputPanel.add(new JLabel("Function D(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField3); exprField3.setText("x^2");

    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel(" M =:", JLabel.RIGHT));
    inputPanel.add(integerM);
    inputPanel.add(new JLabel(" N =:", JLabel.RIGHT));
    inputPanel.add(integerN);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }


  }
    
   
