
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class RungFeh
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, alphaCondn, integerN, tolerance, stepHmax, stepHmin, exprField;
  private JTextArea solution;
  private double A, B, Tol, Alpha, Hmax, Hmin, H, T, W, K1, K2, K3, K4, K5, K6, R, Delta;
  private int I, N;
  private boolean OK;
  private NumberFormat formatter;
  private double yValue, tValue;

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 Hmax = Double.parseDouble(stepHmax.getText());
                 Hmin = Double.parseDouble(stepHmin.getText());
               Alpha = Double.parseDouble(alphaCondn.getText());
               Tol = Double.parseDouble(tolerance.getText());

                OK  = true; 
               solution.setText("");             

           if(inputCheck()){
                solution.append(" T\t"+"W\t"+"H\t"+"R\n");
	       /* STEP 1 */
	       H = Hmax;
	       T = A;
	       W = Alpha;
               solution.append(" "+formatter.format(T)+"\t"+formatter.format(W)+"\t0\t0"+"\n");
                /* STEP 2 */
               while ((T < B) && OK) {
                    /* STEP 3 */
		    K1 = H*functnF(T,W);
                    K2 = H*functnF(T+H/4,W+K1/4);
                    K3 = H*functnF(T+3*H/8,W+(3*K1+9*K2)/32);
                    K4 = H*functnF(T+12*H/13,W+(1932*K1-7200*K2+7296*K3)/2197);
                    K5 = H*functnF(T+H,W+439*K1/216-8*K2+3680*K3/513-845*K4/4104);
                    K6 = H*functnF(T+H/2,W-8*K1/27+2*K2-3544*K3/2565
                         +1859*K4/4104-11*K5/40);
                    /* STEP 4 */
                    R = absVal(K1/360-128*K3/4275-2197*K4/75240.0
                               +K5/50+2*K6/55)/H;
                    /* STEP 5 */
                   if (R <= Tol) {
                      /* STEP 6 */
                      /* APPROXIMATION ACCEPTED */
                      T = T + H;
                      W = W+25*K1/216+1408*K3/2565+2197*K4/4104-K5/5;
                      /* STEP 7 */
                      solution.append(" "+formatter.format(T)+"\t"+formatter.format(W)+"\t"+formatter.format(H)                                                 +"\t"+formatter.format(R)+"\n");
                     }
                    /* STEP 8 */
                    /* TO AVOID UNDERFLOW */
                  if (R > 1.0E-20) Delta = 0.84 * Math.exp(0.25 * Math.log(Tol / R));
                  else Delta = 10.0;
                    /* STEP 9 */
                    /* CALCULATE NEW H */
                  if (Delta <= 0.1) H = 0.1 * H;
                  else {
                      if (Delta >= 4.0) H = 4.0 * H;
                      else H = Delta * H;
                   }
                    /* STEP 10 */
                 if (H > Hmax) H = Hmax;
                    /* STEP 11 */
                 if (H < Hmin) OK = false;
                 else {
                    if (T+H > B)
                     if (absVal(B-T) < Tol) T = B;
                     else H = B - T;
                  }
              }   
           if (!OK) solution.append("Minimal H exceeded\n");
            /* STEP 12 */
            /* PROCESS IS COMPLETE */
          }
         }         
 
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("t", tValue);
		myParser.addVariable("y", yValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2)
   {
    double f;
    tValue = point1;
    yValue = point2;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  

  public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (Tol <=0){
            solution.append("Tolerance must be positive \n");
            OK = false;}

          if (Hmin > Hmax){
            solution.append("Minimum mesh must be less than the maximum mesh spacing\n");
            OK = false;}

          if ((Hmin <=0) || (Hmax <= 0)){
            solution.append("Both Minimum and Maximum mesh spacing must be a positive real \n");
            OK = false;}


          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 public double absVal(double val)
  { 
    if( val >= 0) return val;
    else return -val;
  }  
 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    alphaCondn = new JTextField(4);
    stepHmax = new JTextField(2);
    stepHmin = new JTextField(2);
    tolerance = new JTextField(4);
    exprField = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function f(t,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("y - t^2 + 1");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("Condition Alpha =:", JLabel.RIGHT));
    inputPanel.add(alphaCondn);


    inputPanel.add(new JLabel("Hmin =:", JLabel.RIGHT));
    inputPanel.add(stepHmin);
    inputPanel.add(new JLabel("Hmax =:", JLabel.RIGHT));
    inputPanel.add(stepHmax);
    inputPanel.add(new JLabel("Tolerance =:", JLabel.RIGHT));
    inputPanel.add(tolerance);

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }


  }
    
   
