
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class RungDef
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, AlphaCondn1, AlphaCondn2, integerN, exprField, exprField2;
  private JTextArea solution;
  private double A,B,ALPHA1,ALPHA2,H,T,W1,W2,X11,X12,X21,X22,X31,X32,X41,X42;
  private int I, N;
  private boolean OK;
  private NumberFormat formatter;
  private double x1Value, x2Value, tValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 N = Integer.parseInt(integerN.getText());
                 ALPHA1 = Double.parseDouble(AlphaCondn1.getText());
                 ALPHA2 = Double.parseDouble(AlphaCondn2.getText());

                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
                solution.append("Runge-Kutta Method for Systems with  m = 2.\n\n");
                solution.append(" "+" T\tW1\tW2\n");
                /* STEP 1 */
                H = (B - A) / N;
                T = A;
                /* STEP 2 */
                W1 = ALPHA1;
                W2 = ALPHA2;
                /* STEP 3 */
                solution.append(" "+formatter.format(T)+"\t"+formatter.format(W1)+"\t"+formatter.format(W2)+"\n");
                /* STEP 4 */
            for (I=1; I<=N; I++) {
              /* STEP 5 */
              X11 = H * functnF1(T, W1, W2);
              X12 = H * functnF2(T, W1, W2);
              /* STEP 6 */
              X21 = H * functnF1(T + H / 2.0, W1 + X11 / 2.0, W2 + X12 / 2.0);
              X22 = H * functnF2(T + H / 2.0, W1 + X11 / 2.0, W2 + X12 / 2.0);
              /* STEP 7 */
              X31 = H * functnF1(T + H / 2.0, W1 + X21 / 2.0, W2 + X22 / 2.0);
              X32 = H * functnF2(T + H / 2.0, W1 + X21 / 2.0, W2 + X22 / 2.0);
              /* STEP 8  */
              X41 = H * functnF1(T + H, W1 + X31, W2 + X32);
              X42 = H * functnF2(T + H, W1 + X31, W2 + X32);
              /* STEP 9 */
              W1 = W1 + (X11 + 2.0 * X21 + 2.0 * X31 + X41) / 6.0;
              W2 = W2 + (X12 + 2.0 * X22 + 2.0 * X32 + X42) / 6.0;
              /* STEP 10 */
              T = A + I * H;
              /* STEP 11 */
              solution.append(" "+formatter.format(T)+"\t"+formatter.format(W1)+"\t"+formatter.format(W2)+"\n");  
            }  
          }
        }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
              
 

     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("t", tValue);
		myParser.addVariable("x1", x1Value);
		myParser.addVariable("x2", x2Value);
                myParser.parseExpression(exp);
	}


  public double functnF1(double point1, double point2, double point3)
   {
    double f;
    tValue = point1;
    x1Value = point2;  
    x2Value = point3;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
  public double functnF2(double point1, double point2, double point3)
   {
    double f;
    tValue = point1;
    x1Value = point2;  
    x2Value = point3;  
    parseExp(exprField2.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }

    public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}


          if (N <= 0){
            solution.append("Input a positive number for the number of subintervals\n");
            OK = false;}


          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     
 

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    AlphaCondn1 = new JTextField(4);
    AlphaCondn2 = new JTextField(4);
    integerN = new JTextField(2);
    exprField = new JTextField(20);
    exprField2 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("F1(t,x1,x2) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("-4*x1+3*x2+6");
    inputPanel.add(new JLabel("F2(t,x1,x2)=:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("-2.4*x1+1.6*x2+3.6");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Alpha1 =:", JLabel.RIGHT));
    inputPanel.add(AlphaCondn1);
    inputPanel.add(new JLabel("Alpha2 =:", JLabel.RIGHT));
    inputPanel.add(AlphaCondn2);
    inputPanel.add(new JLabel("N =:", JLabel.RIGHT));
    inputPanel.add(integerN);


    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
