
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Rung
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, integerN, alphaCondn, exprField;
  private JTextArea solution;
  private double A, B, Tol, Alpha, Hmax, Hmin, H, T, W, K1, K2, K3, K4;
  private int I, N;
  private boolean OK;
  private NumberFormat formatter;
  private double yValue, tValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 N = Integer.parseInt(integerN.getText());
                 Alpha = Double.parseDouble(alphaCondn.getText());


                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
                solution.append("  I\t"+" T\t"+"W\n");
                H = (B - A) / N;
                T = A;
                W = Alpha;
                solution.append(" "+0+"\t"+formatter.format(T)+"\t"+formatter.format(W)+"\n");
                /* STEP 2 */
            for (I=1; I<=N; I++) {
              /* STEP 3 */
              /* USE K1, K2, K3, K4 FOR K(1), K(2), K(3), K(4) RESP. */
              K1 = H * functnF(T, W);
              K2 = H * functnF(T + H / 2.0, W + K1 / 2.0);
              K3 = H * functnF(T + H / 2.0, W + K2 / 2.0);
              K4 = H * functnF(T + H, W + K3);
              /* STEP 4 */
              /* COMPUTE W(I) */
              W = W + (K1 + 2.0 * (K2 + K3) + K4) / 6.0;
              /* COMPUTE T(I) */ 
              T = A + I * H;
              /* STEP 5 */
               solution.append(" "+I+"\t"+formatter.format(T)+"\t"+formatter.format(W)+"\n");
             }
                   
          }
        }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("t", tValue);
		myParser.addVariable("y", yValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2)
   {
    double f;
    tValue = point1;
    yValue = point2;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  

  public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (N <=0){
            solution.append("N must be positive \n");
            OK = false;}
          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    alphaCondn = new JTextField(4);
    integerN = new JTextField(2);
    exprField = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function f(t,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("y - t^2 + 1");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel(" N =:", JLabel.RIGHT));
    inputPanel.add(integerN);
    inputPanel.add(new JLabel("Condition Alpha =:", JLabel.RIGHT));
    inputPanel.add(alphaCondn);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }


  }
    
   
