
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Romb
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, nIteration, exprField;
  private JTextArea solution;
  private double A, B, H, X, SUM, M, L, R[][];
  private int I, N, J, K;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 R = new double[2][15];
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 N = Integer.parseInt(nIteration.getText());
                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
                H = (B - A);
               R[0][0] = (functnF(A) + functnF(B))/2*H ;
               solution.append("Romberg Itegration Table:\n");
               solution.append("\n"+formatter.format(R[0][0])+"\n\n");
               
                for (I=2; I<=N; I++){
                  SUM  = 0;
                    M =  Math.floor(Math.exp((I - 2)*Math.log(2)) + 0.5);
                    for(K=1; K<=M; K++) SUM = SUM +functnF(A + (K - 0.5)*H);
                    R[1][0] = (R[0][0] + H*SUM)/2;
                    for(J=2; J<=I; J++){
                      L = Math.floor(Math.exp(2*(J - 1)*Math.log(2)) + 0.5) ;
                      R[1][J-1] = R[1][J-2] +(R[1][J-2] -R[0][J-2])/(L-1);
                      }
                    for(K=1; K<=I; K++)
                      solution.append(formatter.format(R[1][K-1])+"\t");     
                    solution.append("\n\n");
                    H = H/2 ;
                    for(J=1; J<=I; J++) R[0][J-1] = R[1][J-1];
                  }

    
               }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


   public void parseExpression() {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
		myParser.parseExpression(exprField.getText());
	}


  public double functnF(double point)
   {
    double f;
    xValue = point;  
    parseExpression();
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
  public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (N <=0 ){
            solution.append("N must be positive \n");
            OK = false;}
            parseExpression();
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    nIteration = new JTextField(2);
    exprField = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(4,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Function f(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("sin(x)");
    inputPanel.add(new JLabel(" N =:", JLabel.RIGHT));
    inputPanel.add(nIteration);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("endPoint A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel("endPoint B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);endPointB.setText("3.1415926535897932384626433832795");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }



  }
    
   
