
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Ray
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField pointFPL, pointFPR, pointPPL, pointPPR, pointQPL, pointQPR,intN;
  private JTextField  exprField, exprField2,  exprField3;
  private JTextArea solution;
  private double A[][], CO[][][], DCO[][][], X[], C[], AF[], BF[], CF[], DF[];
  private double AP[], BP[], CP[], DP[], AQ[], BQ[], CQ[], DQ[];
  private double T, H, XU, XL, A1, B1, C1, D1, A2, B2, C2, D2, A3, B3, C3, D3;
  private double A4, B4, C4, D4, CC, S, SS, FPL, FPR, PPL, PPR,QPL, QPR;
  private int N, N1, N2, N3, I, J, K, II, JJ, J0, J1, J2, KK, K2, K3, JJ1, JJ2;
  private boolean OK;
  private NumberFormat formatter;
  private NumberFormat formatt;
  private double xValue;

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = new double[21][21]; CO = new double[21][4][4]; DCO = new double[21][4][3]; X = new double[20];
                 C = new double[20]; AF = new double[20]; BF = new double[20]; CF = new double[20]; DF = new double[20];
                 AP = new double[20]; BP = new double[20]; CP = new double[20]; DP = new double[20]; 
                 AQ = new double[20];BQ = new double[20]; CQ = new double[20]; DQ = new double[20];
                 FPL = Double.parseDouble(pointFPL.getText());
                 FPR = Double.parseDouble(pointFPR.getText());
                 PPL = Double.parseDouble(pointPPL.getText());
                 PPR = Double.parseDouble(pointPPR.getText());
                 QPL = Double.parseDouble(pointQPL.getText());
                 QPR = Double.parseDouble(pointQPR.getText());
                 N = Integer.parseInt(intN.getText());
                 OK  = true; 
            solution.setText("");             

            if(inputCheck()){
            solution.setText("");             
      /* STEP 1 */
      H = 1.0/(N+1.0);
      N1 = N+1;
      N2 = N+2;
      N3 = N+3;
      /* Initialize matrix A at zero, note that A[I, N+3] = B[I] */
      for (I=1; I<=N2; I++) 
         for (J=1; J<=N3; J++) 
            A[I-1][J-1] = 0.0;
      /* STEP 2 */
      /* X[1]=0,...,X[I] = (I-1)*H,...,X[N+1] = 1 - H, X[N+2] = 1 */
      for (I=1; I<=N2; I++) X[I-1] = (I-1.0)*H;
      /* STEPS 3 and 4 are implemented in what follows.
          Initialize coefficients CO[I,J,K], DCO[I,J,K] */
      for (I=1; I<=N2; I++)
         for (J=1; J<=4; J++) {
            for (K=1; K<=4; K++) {
               CO[I-1][J-1][K-1] = 0.0; 
               if (K != 4) DCO[I-1][J-1][K-1] = 0.0;
            }  
            /* JJ corresponds the coefficients of phi and phi'
               to the proper interval involving J */
            JJ = I+J-3;
            PHICO();
            DPHICO();
         }
      /* Output the basis functions. */
      solution.append("Basis Function: A + B*X + C*X**2 + D*X**3\n\n");
      solution.append("\t\tA\tB\tC\tD\n\n");
      for (I=1; I<=N2; I++) {
         solution.append("phi("+I+" )\n\n");
         for (J=1; J<=4; J++) 
            if ((I != 1) || ((J != 1) && (J != 2))) 
               if ((I != 2) || (J != 2)) 
                  if ((I != N1) || (J != 4)) 
                     if ((I != N2) || ((J != 3) && (J != 4))) {
                        JJ1 = I+J-3;
                        JJ2 = I+J-2;
                        solution.append(PadWithBlanks("On (X("+JJ1+" ), X("+JJ2+"))",18));
                        for (K=1; K<=4; K++)
                          // solution.append("\t"+formatter.format(CO[I-1][J-1][K-1]));
                             solution.append(PadWithBlanks(""+formatter.format(CO[I-1][J-1][K-1]), 20));
                        solution.append("\n\n");
                     }  
      }
      /* Obtain coefficients for F, P, Q - NOTE _ the fourth and fifth
         arguements in COEF are the derivatives of F, P, or Q evaluated
         at 0 and 1 respectively. */
      COEF(1, N2, N1, FPL, FPR, AF, BF, CF, DF, X, H);
      COEF(2, N2, N1, PPL, PPR, AP, BP, CP, DP, X, H);
      COEF(3, N2, N1, QPL, QPR, AQ, BQ, CQ, DQ, X, H);
      /* STEPS 5 - 9 are implemented in what follows */
      for (I=1; I<=N2; I++) {
         /* indices for limits of integration for A[I,I] and B[I] */
         J1 = MINO(I+2,N+2);
         J0 = MAXO(I-2,1);
         J2 = J1 - 1;
         /* integrate over each subinterval where phi(I) nonzero */
         for (JJ=J0; JJ<=J2; JJ++) {
            /* limits of integration for each call */
            XU = X[JJ];
            XL = X[JJ-1];
            /* coefficients of bases */
            K = INTE(I,JJ);
            A1 = DCO[I-1][K-1][0];
            B1 = DCO[I-1][K-1][1];
            C1 = DCO[I-1][K-1][2];
            D1 = 0.0;
            A2 = CO[I-1][K-1][0];
            B2 = CO[I-1][K-1][1];
            C2 = CO[I-1][K-1][2];
            D2 = CO[I-1][K-1][3];
            /* call subprogram for integrations */
            A[I-1][I-1] = A[I-1][I-1]+
                     XINT(XU,XL,AP[JJ-1],BP[JJ-1],CP[JJ-1],DP[JJ-1],
                     A1,B1,C1,D1,A1,B1,C1,D1)+
                     XINT(XU,XL,AQ[JJ-1],BQ[JJ-1],CQ[JJ-1],DQ[JJ-1],
                     A2,B2,C2,D2,A2,B2,C2,D2);
            A[I-1][N+2] = A[I-1][N+2] +
                       XINT(XU,XL,AF[JJ-1],BF[JJ-1],CF[JJ-1],DF[JJ-1],
                       A2,B2,C2,D2,1.0,0.0,0.0,0.0);
         }  
         /* compute A[I,J] for J = I+1, ..., Min(I+3,N+2) */
         K3 = I+1;
         if (K3 <= N2) {
            K2 = MINO(I+3,N+2);
            for (J=K3; J<=K2; J++) {
               J0 = MAXO(J-2,1);
               for (JJ=J0; JJ<=J2; JJ++) {
                  XU = X[JJ];
                  XL = X[JJ-1];
                  K = INTE(I,JJ);
                  A1 = DCO[I-1][K-1][0];
                  B1 = DCO[I-1][K-1][1];
                  C1 = DCO[I-1][K-1][2];
                  D1 = 0.0;
                  A2 = CO[I-1][K-1][0];
                  B2 = CO[I-1][K-1][1];
                  C2 = CO[I-1][K-1][2];
                  D2 = CO[I-1][K-1][3];
                  K = INTE(J,JJ);
                  A3 = DCO[J-1][K-1][0];
                  B3 = DCO[J-1][K-1][1];
                  C3 = DCO[J-1][K-1][2];
                  D3 = 0.0;
                  A4 = CO[J-1][K-1][0];
                  B4 = CO[J-1][K-1][1];
                  C4 = CO[J-1][K-1][2];
                  D4 = CO[J-1][K-1][3];
                  A[I-1][J-1] = A[I-1][J-1] +
                            XINT(XU,XL,AP[JJ-1],BP[JJ-1],
                            CP[JJ-1],DP[JJ-1],A1,B1,C1,D1,
                            A3,B3,C3,D3)+
                            XINT(XU,XL,AQ[JJ-1],BQ[JJ-1],
                            CQ[JJ-1],DQ[JJ-1],A2,B2,C2,D2,
                            A4,B4,C4,D4);
               }  
               A[J-1][I-1] = A[I-1][J-1];
            }  
         }  
      }  
      /* STEP 10 */
      for (I=1; I<=N1; I++) {
         for (J=I+1; J<=N2; J++) {
            CC = A[J-1][I-1]/A[I-1][I-1];
            for (K=I+1; K<=N3; K++) A[J-1][K-1] = A[J-1][K-1]-CC*A[I-1][K-1];
            A[J-1][I-1] = 0.0;
         }  
      }  
      C[N2-1] = A[N2-1][N3-1]/A[N2-1][N2-1];
      for (I=1; I<=N1; I++) {
         J = N1-I+1;
         C[J-1] = A[J-1][N3-1];
         for (KK=J+1; KK<=N2; KK++) C[J-1] = C[J-1]-A[J-1][KK-1]*C[KK-1];
         C[J-1] = C[J-1]/A[J-1][J-1];
      }  
      /* STEP 11 */
      /* output coefficients */
      solution.append("\nCoefficients:  c(1), c(2), ... , c(n)\n\n");
      for (I=1; I<=N2; I++) solution.append(""+ formatter.format(C[I-1])+"\n");
      solution.append("\n");
      /* compute and output value of the approximation at the nodes */
      solution.append("The approximation evaluated at the nodes:\n\n");
      solution.append("Node\tValue\n\n");
      for (I=1; I<=N2; I++) {
         S = 0.0;
         for (J=1; J<=N2; J++) {
            J0 = MAXO(J-2,1);
            J1 = MINO(J+2,N+2);
            SS = 0.0;
            if ((I < J0) || (I >= J1)) S = S + C[J-1]*SS;
            else {
               K = INTE(J,I);
               SS = ((CO[J-1][K-1][3]*X[I-1]+CO[J-1][K-1][2])*X[I-1]+
                     CO[J-1][K-1][1])*X[I-1]+CO[J-1][K-1][0];
               S = S + C[J-1]*SS;
            }  
         }      
         solution.append(""+formatter.format(X[I-1])+"\t"+formatter.format( S)+"\n");
  }}}
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


   public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
		myParser.parseExpression(exp);
	}


  public String PadWithBlanks(String numAsString, int width)
      {
       int blanksToPad = width - numAsString.length();
       for(int j = 1; j <= blanksToPad; j++)
           numAsString = " " + numAsString ;
       return numAsString;
      }

  public double functnF(double point)
   {
    double f;
    xValue = point;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }

    public double functnP(double point)
   {
    double p;
    xValue = point;  
    parseExp(exprField2.getText());
    p = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return p;
   }

  public double functnQ(double point)
   {
    double q;
    xValue = point;  
    parseExp(exprField3.getText());
    q = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return q;
   }


  public boolean inputCheck()
   {
        String errorInfo;
  
          if (N <= 0 ){
            solution.append("N must be positive integer\n");
            OK = false;}

            parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
            parseExp(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
           parseExp(exprField3.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          return OK;
   }     

public int MINO(int I, int J)
{
   if (J < I) return J;
   else return I;
}

public int MAXO(int I, int J) 
{
   if (J > I) return J;
   else return I;
}

public int INTE(int J, int JJ)
{
   int inte;
   
   inte = JJ - J + 3;
   return inte;
}

public void DPHICO()
{
   double EE,E, AA, BB, CC;
   boolean OK;

   DCO[I-1][J-1][0] = 0.0;
   DCO[I-1][J-1][1] = 0.0;
   DCO[I-1][J-1][2] = 0.0;
   E = I - 1.0;
   OK = true;
   if ( (JJ < I-2) || (JJ >= I+2) ) OK = false;
   if ( (I == 1) && (JJ < I) ) OK = false;
   if ( (I == 2) && (JJ < I-1) ) OK = false;
   if ( (I == N+1) && (JJ > N+1) ) OK = false;
   if ( (I == N+2) && (JJ >= N+2) ) OK = false;
   if (OK) {
      if (JJ <= I-2) {
         DCO[I-1][J-1][0] = ((E-4.0)*E+4.0)/(8.0*H);
         DCO[I-1][J-1][1] = (-E+2.0)/(4.0*H*H);
         DCO[I-1][J-1][2] = 1.0/(8.0*H*H*H);
         OK = false;
      }
      else {
         if (JJ > I) {
            DCO[I-1][J-1][0] = ((-E-4.0)*E-4.0)/(8.0*H);
            DCO[I-1][J-1][1] = (E+2.0)/(4.0*H*H);
            DCO[I-1][J-1][2] = -1.0/(8.0*H*H*H);
            OK = false;
         }  
         else {
            if (JJ > I-1) {
               DCO[I-1][J-1][0] = (3.0*E+4.0)*E/(8.0*H);
               DCO[I-1][J-1][1] = (-3.0*E-2.0)/(4.0*H*H);
               DCO[I-1][J-1][2] = 3.0/(8.0*H*H*H);
               if ( (I != 1) && (I != N+1) ) OK = false;
            }  
            else {
               DCO[I-1][J-1][0] = (-3.0*E+4.0)*E/(8.0*H);
               DCO[I-1][J-1][1] = (3.0*E-2.0)/(4.0*H*H);
               DCO[I-1][J-1][2] = -3.0/(8.0*H*H*H);
               if ( (I != 2) && (I != N+2) ) OK = false;
            }  
         }  
      }  
   }  
   if (OK) {
      if ( I <= 2 ) {
         AA = -1.0/(8.0*H);
         BB = 1.0/(4.0*H*H);
         CC = -1.0/(8.0*H*H*H);
         if ( I == 2 ) {
            DCO[I-1][J-1][0] = DCO[I-1][J-1][0] - AA;
            DCO[I-1][J-1][1] = DCO[I-1][J-1][1] - BB;
            DCO[I-1][J-1][2] = DCO[I-1][J-1][2] - CC;
         }  
         else {
            DCO[I-1][J-1][0] = DCO[I-1][J-1][0] - 4*AA;
            DCO[I-1][J-1][1] = DCO[I-1][J-1][1] - 4*BB;
            DCO[I-1][J-1][2] = DCO[I-1][J-1][2] - 4*CC;
         }  
      }  
      else {
         EE = N+2.0;
         AA = ((EE-4.0)*EE+4.0)/(8.0*H);
         BB = (-EE+2.0)/(4.0*H*H);
         CC = 1.0/(8.0*H*H*H);
         if ( I == N+1 ) {
            DCO[I-1][J-1][0] = DCO[I-1][J-1][0] - AA;
            DCO[I-1][J-1][1] = DCO[I-1][J-1][1] - BB;
            DCO[I-1][J-1][2] = DCO[I-1][J-1][2] - CC;
         }  
         else {
            DCO[I-1][J-1][0] = DCO[I-1][J-1][0] - 4*AA;
            DCO[I-1][J-1][1] = DCO[I-1][J-1][1] - 4*BB;
            DCO[I-1][J-1][2] = DCO[I-1][J-1][2] - 4*CC;
         }  
      }  
   }  
}

public void PHICO()
{
   double EE,E, AA, BB, CC,DD;
   boolean OK;

   CO[I-1][J-1][0] = 0.0;
   CO[I-1][J-1][1] = 0.0;
   CO[I-1][J-1][2] = 0.0;
   CO[I-1][J-1][3] = 0.0;
   E = I - 1.0;
   OK = true;
   if ( (JJ < I-2) || (JJ >= I+2) ) OK = false;
   if ( (I == 1) && (JJ < I) ) OK = false;
   if ( (I == 2) && (JJ < I-1) ) OK = false;
   if ( (I == N+1) && (JJ > N+1) ) OK = false;
   if ( (I == N+2) && (JJ >= N+2) ) OK = false;
   if (OK) {
      if (JJ <= I-2) {
         CO[I-1][J-1][0] = (((-E+6.0)*E-12.0)*E+8.0)/24.0;
         CO[I-1][J-1][1] = ((E-4.0)*E+4.0)/(8.0*H);
         CO[I-1][J-1][2] = (-E+2.0)/(8.0*H*H);
         CO[I-1][J-1][3] = 1.0/(24.0*H*H*H);
         OK = false;
      }  
      else {
         if (JJ > I) {
            CO[I-1][J-1][0] = (((E+6.0)*E+12.0)*E+8.0)/24.0;
            CO[I-1][J-1][1] = ((-E-4.0)*E-4.0)/(8.0*H);
            CO[I-1][J-1][2] = (E+2.0)/(8.0*H*H);
            CO[I-1][J-1][3] = -1.0/(24.0*H*H*H);
            OK = false;
         }  
         else {
            if (JJ > I-1) {
               CO[I-1][J-1][0] = ((-3.0*E-6.0)*E*E+4.0)/24.0;
               CO[I-1][J-1][1] = (3.0*E+4.0)*E/(8.0*H);
               CO[I-1][J-1][2] = (-3.0*E-2.0)/(8.0*H*H);
               CO[I-1][J-1][3] = 1.0/(8.0*H*H*H);
               if ( (I != 1) && (I != N+1) ) OK = false;
            }  
            else {
               CO[I-1][J-1][0] = ((3.0*E-6.0)*E*E+4.0)/24.0;
               CO[I-1][J-1][1] = (-3.0*E+4.0)*E/(8.0*H);
               CO[I-1][J-1][2] = (3.0*E-2.0)/(8.0*H*H);
               CO[I-1][J-1][3] = -1.0/(8.0*H*H*H);
               if (( I != 2) && (I != N+2)) OK = false;
            }  
         }  
      }  
   }
   if (OK) {
      if ( I <= 2 ) {
         AA = 1.0/24.0;
         BB = -1.0/(8.0*H);
         CC = 1.0/(8.0*H*H);
         DD = -1.0/(24.0*H*H*H);
         if ( I == 2 ) {
            CO[I-1][J-1][0] = CO[I-1][J-1][0] - AA;
            CO[I-1][J-1][1] = CO[I-1][J-1][1] - BB;
            CO[I-1][J-1][2] = CO[I-1][J-1][2] - CC;
            CO[I-1][J-1][3] = CO[I-1][J-1][3] - DD;
         }  
         else { 
            CO[I-1][J-1][0] = CO[I-1][J-1][0] - 4.0*AA;
            CO[I-1][J-1][1] = CO[I-1][J-1][1] - 4.0*BB;
            CO[I-1][J-1][2] = CO[I-1][J-1][2] - 4.0*CC;
            CO[I-1][J-1][3] = CO[I-1][J-1][3] - 4.0*DD;
         }  
      }  
      else {
         EE = N+2.0;
         AA = (((-EE+6.0)*EE-12.0)*EE+8.0)/24.0;
         BB = ((EE-4.0)*EE+4.0)/(8.0*H);
         CC = (-EE+2.0)/(8.0*H*H);
         DD = 1.0/(24.0*H*H*H);
         if ( I == N+1 ) {
            CO[I-1][J-1][0] = CO[I-1][J-1][0] - AA;
            CO[I-1][J-1][1] = CO[I-1][J-1][1] - BB;
            CO[I-1][J-1][2] = CO[I-1][J-1][2] - CC;
            CO[I-1][J-1][3] = CO[I-1][J-1][3] - DD;
         }  
         else {
            CO[I-1][J-1][0] = CO[I-1][J-1][0] - 4.0*AA;
            CO[I-1][J-1][1] = CO[I-1][J-1][1] - 4.0*BB;
            CO[I-1][J-1][2] = CO[I-1][J-1][2] - 4.0*CC;
            CO[I-1][J-1][3] = CO[I-1][J-1][3] - 4.0*DD;
         }  
      }  
   }  
}

public double XINT(double XU, double XL, double A1, double B1, double C1, double D1, double A2, double B2, double C2, double D2, double A3, double B3, double C3, double D3)
{
   double C[]; C = new double[20];
   double AA,BB,CC,DD,EE,FF,GG,XHIGH,XLOW,xint;
   int I;
  
   AA = A1*A2;
   BB = A1*B2+A2*B1;
   CC = A1*C2+B1*B2+C1*A2;
   DD = A1*D2+B1*C2+C1*B2+D1*A2;
   EE = B1*D2+C1*C2+D1*B2;
   FF = C1*D2+D1*C2;
   GG = D1*D2;
   C[9] = AA*A3;
   C[8] = (AA*B3+BB*A3)/2.0;
   C[7] = (AA*C3+BB*B3+CC*A3)/3.0;
   C[6] = (AA*D3+BB*C3+CC*B3+DD*A3)/4.0;
   C[5] = (BB*D3+CC*C3+DD*B3+EE*A3)/5.0;
   C[4] = (CC*D3+DD*C3+EE*B3+FF*A3)/6.0;
   C[3] = (DD*D3+EE*C3+FF*B3+GG*A3)/7.0;
   C[2] = (EE*D3+FF*C3+GG*B3)/8.0;
   C[1] = (FF*D3+GG*C3)/9.0;
   C[0] = (GG*D3)/10.0;
   XHIGH = 0.0;
   XLOW = 0.0;
   for (I=1; I<=10; I++) {
      XHIGH = (XHIGH + C[I-1])*XU;
      XLOW = (XLOW + C[I-1])*XL;
   }
   xint = XHIGH - XLOW;
   return xint;
}

public void COEF(int L, int N, int M, double FPO, double FPN, double A[], double B[], double C[], double D[], double X[], double H)
{
   double AA[], BB[], CC[], DD[], XA[], XL[], XU[], XZ[];
          AA = new double[25]; BB = new double[25]; CC = new double[25]; DD =new double[25];
          XA = new double[25]; XL=new double[25]; XU =new double[25]; XZ =new double[25];
   int I, J;

   for (I=1; I<=N; I++)
      switch (L) {
         case 1:
            AA[I-1] = functnF(X[I-1]);
            break;
         case 2:
            AA[I-1] = functnP(X[I-1]);
            break;
         case 3:
            AA[I-1] = functnQ(X[I-1]);
            break;
      }  
   XA[0] = 3.0*(AA[1]-AA[0])/H - 3.0*FPO;
   XA[N-1] = 3.0*FPN - 3.0*(AA[N-1]-AA[N-2])/H;
   XL[0] = 2.0*H;
   XU[0] = 0.5;
   XZ[0] = XA[0]/XL[0];
   for (I=2; I<=M; I++) {
      XA[I-1] = 3.0*(AA[I]-2.0*AA[I-1]+AA[I-2])/H;
      XL[I-1] = H*(4.0-XU[I-2]);
      XU[I-1] = H/XL[I-1];
      XZ[I-1] = (XA[I-1]-H*XZ[I-2])/XL[I-1];
   }  
   XL[N-1] = H*(2.0-XU[N-2]);
   XZ[N-1] = (XA[N-1]-H*XZ[N-2])/XL[N-1];
   CC[N-1] = XZ[N-1];
   for (I=1; I<=M; I++) {
      J = N-I;
      CC[J-1] = XZ[J-1]-XU[J-1]*CC[J];
      BB[J-1] = (AA[J]-AA[J-1])/H -H*(CC[J]+2.0*CC[J-1])/3.0;
      DD[J-1] = (CC[J]-CC[J-1])/(3.0*H);
   }  
   for (I=1; I<=M; I++) {
      A[I-1] = ((-DD[I-1]*X[I-1]+CC[I-1])*X[I-1]-BB[I-1])*X[I-1]+AA[I-1];
      B[I-1] = (3.0*DD[I-1]*X[I-1]-2.0*CC[I-1])*X[I-1]+BB[I-1];
      C[I-1] = CC[I-1]-3.0*DD[I-1]*X[I-1];
      D[I-1] = DD[I-1];
   }   
}

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    pointFPL = new JTextField(4);
    pointFPR = new JTextField(4);
    pointPPL = new JTextField(4);
    pointPPR = new JTextField(4);
    pointQPL = new JTextField(4);
    pointQPR = new JTextField(4);
    intN = new JTextField(4);
    exprField = new JTextField(20);
    exprField2 = new JTextField(20);
    exprField3 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(6,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel(" f(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("2*pi^2*sin(pi*x)");
    inputPanel.add(new JLabel(" p(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("1");
    inputPanel.add(new JLabel(" q(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField3); exprField3.setText("pi^2");


    inputPanel.add(new JLabel("f '(0) =:", JLabel.RIGHT));
    inputPanel.add(pointFPL);pointFPL.setText("62.01255336");
    inputPanel.add(new JLabel("f '(1) =:", JLabel.RIGHT));
    inputPanel.add(pointFPR);pointFPR.setText("-62.01255336");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("p '(0) =:", JLabel.RIGHT));
    inputPanel.add(pointPPL);pointPPL.setText("0");
    inputPanel.add(new JLabel("p '(1) =:", JLabel.RIGHT));
    inputPanel.add(pointPPR);pointPPR.setText("0");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("q '(0) =:", JLabel.RIGHT));
    inputPanel.add(pointQPL);pointQPL.setText("0");
    inputPanel.add(new JLabel("q '(1) =:", JLabel.RIGHT));
    inputPanel.add(pointQPR);pointQPR.setText("0");
    inputPanel.add(new JLabel("intervals N:", JLabel.RIGHT));
    inputPanel.add(intN);intN.setText("9");


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
    formatt = NumberFormat.getNumberInstance();
    formatt.setMaximumFractionDigits(5);
    formatt.setMinimumFractionDigits(5);
  }


  }
    
   
