import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class QrA
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField nDegree, matAField, matBField, tolField, iteratn;
  private JTextArea solution;
  private int N, I, J, K, M, MM, L; 
  private boolean OK;
  private NumberFormat formatter;
  private double A[], B[], BC[], C[], D[], Q[], R[], S[], X[], Y[], Z[];
  private double TOL, B1, C1, D1, X1, X2, SHIFT;
  

  public void init() {
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[10]; B = new double[10]; C = new double[10];
                X = new double[10]; Y = new double[9]; B = new double[10]; 
                Z = new double[9]; BC = new double[10]; D = new double[10];
                Q = new double[10]; R = new double[9]; S = new double[10];
                N = Integer.parseInt(nDegree.getText());
                L = Integer.parseInt(iteratn.getText());
                TOL = Double.parseDouble(tolField.getText());

                OK = true; 
                toArray(matAField.getText(), A);
                toArray(matBField.getText(), BC);
                for(I=2; I<=N; I++) B[I-1] = BC[I-2]; 
                solution.setText("");   

           if(inputCheck())
             {
            solution.setText("");       
            solution.append("The Qr Method\n\n");

       /* STEP 1 */
      SHIFT = 0.0;
      K = 1;
      /* STEP 2 */
      while ((K <= L) && OK) {
         solution.append( "Iteration number ="+ K);
         solution.append( "\nThe array A is now as follows:\n");
         solution.append( "Diagonal:\n");
         for (I=1; I<=N; I++) solution.append( " "+formatter.format(A[I-1])+"      ");
         solution.append( "\nOff diagonal:\n");
         for (I=2; I<=N; I++) solution.append( " "+formatter.format(B[I-1])+"      ");
         solution.append( "\n");
         /* Steps 3-7 test for success  */
         /* STEP 3  */
         if (Math.abs(B[N-1]) <= TOL) {
            A[N-1] = A[N-1] + SHIFT;
            solution.append( "Eigenvalue = "+formatter.format(A[N-1]));
            N--;
         }  
         /* STEP 4   */
         if (Math.abs(B[1]) <= TOL) {
            A[0] = A[0] + SHIFT;
            solution.append( "\nEigenvalue = "+ formatter.format(A[0]));
            N--;
            A[0] = A[1];
            for (J=2; J<=N; J++) {
               A[J-1] = A[J];
               B[J-1] = B[J];
            }  
         }  
         /* STEP 5  */
         if (N == 0) OK = false;
         /* STEP 6   */
         if (N == 1) {
            A[0] = A[0] + SHIFT;
            solution.append( "\nEigenvalue = "+ formatter.format(A[0]));
            OK = false;
         }
         /* STEP 7  */
         if (OK) {
            M = N - 1;
            if (M >= 2) {
               for (I=2; I<=M; I++) 
                  if (Math.abs(B[I-1]) <= TOL) {
                     OK = false;
                     J = I;
                  }
               if (!OK) {
                  solution.append( "Split the matrix into\n");
                  for (I=1; I<=J-1; I++) solution.append(""+formatter.format(A[I-1])+"  ");
                  solution.append("\n");
                  for (I=2; I<=J-1; I++) solution.append(""+formatter.format(B[I-1])+"  ");
                  solution.append("\n and \n");
                  for (I=J; I<=N; I++) solution.append(""+formatter.format(A[I-1])+"  ");
                  solution.append("\n");
                  for (I=J+1; I<=N; I++) solution.append(""+formatter.format(B[I-1])+"  ");
                  solution.append("\n");
               }
            }  
         }
         if (OK) {
            /* STEP 8 */
            /* compute shift */
            B1 = -(A[N-1] + A[N-2]);
            C1 = A[N-1] * A[N-2] - B[N-1] * B[N-1];
            D1 = B1 * B1 - 4.0 * C1;
            if (D1 < 0.0) {
               solution.append( "Problem with complex roots, D1 = "+ D1);
               OK = false;
            }  
            else {
               D1 = Math.sqrt( D1 );
               /*  STEP 9   */
               if (B1 > 0.0) {
                  X1 = -2.0 * C1 / (B1 + D1);
                  X2 = -(B1 + D1) / 2.0;
               }     
               else {
                  X1 = (D1 - B1) / 2.0;
                  X2 = 2.0 * C1 / (D1 - B1);
               }  
               /* if N = 2 then the 2 eigenvalues have
                  been computed */
               /*  STEP 10  */
               if (N == 2) {
                  X1 = X1 + SHIFT;
                  X2 = X2 + SHIFT;
                  solution.append( "\nThe last two eigenvalues ");
                  solution.append( "are: "+ X1+"       "+ X2);
                  OK = false;
               }  
               else {
                  /* STEP 11 */
                  if (Math.abs(A[N-1]-X1) > Math.abs(A[N-1]-X2)) X1 = X2;
                  /* STEP 12 */
                  /* accumulate shift */
                  SHIFT = SHIFT + X1;
                  /* STEP 13*/
                  /* perform shift */
                  for (I=1; I<=N; I++) D[I-1] = A[I-1] - X1;
                  /* STEP 14 and 15 compute R(K) */
                  /* STEP 14 */
                  X[0] = D[0];
                  Y[0] = B[1];
                  /* STEP 15 */
                  for (J=2; J<=N; J++) {
                     Z[J-2] = Math.sqrt((X[J-2]*X[J-2])+(B[J-1]*B[J-1]));
                     C[J-1] = X[J-2]/Z[J-2];
                     S[J-1] = B[J-1]/Z[J-2];
                     Q[J-2] = C[J-1]*Y[J-2]+S[J-1]*D[J-1];
                     X[J-1] = C[J-1]*D[J-1]-S[J-1]*Y[J-2];
                     if (J != N) {
                        R[J-2] = S[J-1]*B[J];
                        Y[J-1] = C[J-1]*B[J];
                     }  
                  }  
                  M = N - 1;
                  MM = N - 2;
                  /* Steps 16-18 compute A(K+1) */
                  /* STEP 16 */
                  Z[N-1] = X[N-1];
                  A[0] = C[1]*Z[0]+S[1]*Q[0];
                  B[1] = S[1]*Z[1];
                  /* STEP 17 */
                  if (N > 2) {
                     for (J=2; J<=M; J++) {
                        A[J-1] = C[J]*C[J-1]*Z[J-1]+S[J]*Q[J-1];
                        B[J] = S[J]*Z[J];
                     }  
                  }  
                  /* STEP 18 */
                  A[N-1] = C[N-1] * Z[N-1];
               }  
            }  
         }  
         /* STEP 19 */
         K++;  
      }
      /* STEP 20 */
      if (OK && (K > L)) 
        solution.append( "Maximum Number of Iterations Exceeded.\n");
      /* the process is complete */
    }
}


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }

//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************


  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i= 0; i< charArray.length; i++)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }


  public boolean inputCheck()
   {
   
          if (N <= 1 ){
            solution.append("Dimension must be a positive integer greater than 1. \n");
          OK = false;}
          if (L <= 0 ){
            solution.append("Number of Iterations must be a positive integer. \n");
          OK = false;}

          if (TOL <= 0 ){
            solution.append("Tolerance must be a positive number. \n");
          OK = false;}


          return OK;

   }   
 


   public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    tolField = new JTextField(2);
    iteratn = new JTextField(2);
    matAField = new JTextField(40);
    matBField = new JTextField(40);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(3,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Dimension n =:", JLabel.RIGHT));
    inputPanel.add(nDegree);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Iterations  =:", JLabel.RIGHT));
    inputPanel.add(iteratn);
    inputPanel.add(new JLabel("Tolerance  =:", JLabel.RIGHT));
    inputPanel.add(tolField);


    JPanel inputPanel2 = new JPanel(new GridLayout(3,2));

    inputPanel2.add(new JLabel("Diagonal of A =:", JLabel.RIGHT));
    inputPanel2.add(matAField); matAField.setText("3,3,3");

    inputPanel2.add(new JLabel("Off diagonal of A =:", JLabel.RIGHT));
    inputPanel2.add(matBField); matBField.setText("1,1");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }


  }
    
   
