import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class Powe
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField nDegree, matAField, matXField, tolField, iteratn;
  private JTextArea solution;
  private int N, I, J, K, NN, LP; 
  private boolean OK, inputCancel;
  private NumberFormat formatter;
  private double A[][], X[], Y[];
  private double T, AMAX, YMU, ERR, TOL;
  

  public void init() {
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[10][10]; 
                X = new double[10]; Y = new double[10];

                N = Integer.parseInt(nDegree.getText());
                NN = Integer.parseInt(iteratn.getText());
                TOL = Double.parseDouble(tolField.getText());

                OK = true;
                arrayInput(A, matAField.getText());
                toArray(matXField.getText(), X);
                solution.setText(""); 

           if(inputCheck())
             {
            solution.setText("");       
            solution.append("The Power Method\n\n");
            solution.append("iteratn\t approx\t approx eigenvector\n");
      /* STEP 1 */
      K = 1;
      /* STEP 2 */
      LP = 1;
      AMAX = Math.abs(X[0]);
      for (I=2; I<=N; I++) {
         if (Math.abs(X[I-1]) > AMAX) {
            AMAX = Math.abs(X[I-1]);
            LP = I;
         }  
      }  
      /* STEP 3 */
      for (I=1; I<=N; I++) X[I-1] = X[I-1] / AMAX;
      /* STEP 4 */
      while ((K <= NN) && OK) {
         /* STEP 5 */
         for (I=1; I<=N; I++) {
            Y[I-1] = 0.0;
            for (J=1; J<=N; J++) Y[I-1] = Y[I-1] + A[I-1][J-1] * X[J-1];
         }  
         /* STEP 6 */
         YMU = Y[LP-1];
         /* STEP 7 */
         LP = 1;
         AMAX = Math.abs(Y[0]);
         for (I=2; I<=N; I++) {
            if (Math.abs(Y[I-1]) > AMAX) {
               AMAX = Math.abs(Y[I-1]);
               LP = I;
            }  
         }  
         /* STEP 8 */
         if (AMAX <= 0) {
            solution.append("0 eigenvalue - select another ");
            solution.append("initial vector and begin again\n");
            OK = false;
         }  
         else {
            /* STEP 9 */
            ERR = 0.0;
            for (I=1; I<=N; I++) {
               T = Y[I-1] / Y[LP-1];
               if (Math.abs(X[I-1] - T) > ERR) 
                  ERR = Math.abs(X[I-1] - T);
               X[I-1] = T;
            }  
            solution.append(""+K+"\t"+ formatter.format(YMU)+"\t");
            for (I=1; I<=N; I++) solution.append(""+formatter.format(X[I-1])+"\t");
            solution.append("\n");
            /* STEP 10 */
            if (ERR <= TOL) {
               solution.append("\n\nThe eigenvalue = "+formatter.format(YMU));
               solution.append(" to tolerance = " +TOL);
               solution.append("\nobtained on iteration number = "+ K+"\n\n");
               solution.append("Unit eigenvector is :\n\n");
               for (I=1; I<=N; I++) solution.append(""+formatter.format(X[I-1])+"   ");
               solution.append("\n");
               OK = false;
            }  
            /* STEP 11 */
            K++;
         }  
      }  
      /* STEP 12 */
      if (K > NN) 
         solution.append("Method did not converge within "+NN+" iterations\n");
      
      }
}


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************


  public void arrayInput(double arr[][], String str){

     try{
 
      String[] charArray = StringtoArray(str,","); 
     if(N>0){
      if(N>(charArray.length/N)) {
//         solution.append("Dimension is greater than matrix entered\n");
         inputCancel = true; 
         }
       else{
      for(int i = 0; i< N; i++){
  
        for(int j=0;j < N; ++j)
             arr[i][j] = Double.parseDouble(charArray[N*i +j]);
       }
      }
     }
    }
   catch(NumberFormatException ex){ inputCancel= true; }       
  }

  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i= 0; i< charArray.length; i++)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }


  public boolean inputCheck()
   {
   
          if (N <= 0 ){
            solution.append("The Number of Equations N must be a positive integer. \n");
          OK = false;}
          if (NN <= 0 ){
            solution.append("Number of Iterations must be a positive integer. \n");
          OK = false;}

          if (TOL <= 0 ){
            solution.append("Tolerance must be a positive number. \n");
          OK = false;}


        if (inputCancel){
            solution.append("Dimension is greater than matrix entered\n");
            solution.append("Values must be entered for matrix. \n");
            inputCancel = false;
          OK = false;}
          return OK;

   }    


   public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    tolField = new JTextField(2);
    iteratn = new JTextField(2);
    matAField = new JTextField(40);
    matXField = new JTextField(40);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(3,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Dimension n =:", JLabel.RIGHT));
    inputPanel.add(nDegree);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Iterations  =:", JLabel.RIGHT));
    inputPanel.add(iteratn);
    inputPanel.add(new JLabel("Tolerance  =:", JLabel.RIGHT));
    inputPanel.add(tolField);


    JPanel inputPanel2 = new JPanel(new GridLayout(3,2));

    inputPanel2.add(new JLabel("A(i,j) in row form. Separate elements with commas \",\" A =:", JLabel.RIGHT));
    inputPanel2.add(matAField); matAField.setText("-4, 14, 0, -5, 13, 0, -1, 0, 2");

    inputPanel2.add(new JLabel("X(i), initial approximation. Separate elements with commas \",\" X =:", JLabel.RIGHT));
    inputPanel2.add(matXField); matXField.setText("1,1,1");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

 

  }
    
   
