
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class PoissonE
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB,endPointC, endPointD, intM, intN, exprField, exprField2, tolerance, iterations;
  private JTextArea solution;
  private double W[][], X[], Y[]; 
  private double TOL, A, B, C, D, H, K, V, VV, Z, E, ALPHA, BETA;
  private int I, J, M, N, NN, M1, M2, N1, N2, L, LL;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue, yValue;

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 W = new double[26][26]; X = new double[26]; Y = new double[26];
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 C = Double.parseDouble(endPointC.getText());
                 D = Double.parseDouble(endPointD.getText());
                 TOL = Double.parseDouble(tolerance.getText());
                 NN = Integer.parseInt(iterations.getText());
                 M = Integer.parseInt(intM.getText());
                 N = Integer.parseInt(intN.getText());

                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
            solution.setText("");    
      M1 = M - 1;
      M2 = M - 2;
      N1 = N - 1;
      N2 = N - 2;
      /* STEP 1 */
      H = (B - A) / N;
      K = (D - C) / M;
      /* STEPS 2 and 3 construct mesh points */
      /* STEP 2 */
      for (I=0; I<=N; I++) X[I] = A + I * H; 
      /* STEP 3 */
      for (J=0; J<=M; J++) Y[J] = C + J * K;
      /* STEP 4 */
      for (I=1; I<=N1; I++) {
         W[I][0] = functnG(X[I],Y[0]);
         W[I][M] = functnG(X[I],Y[M]);
      }  
      for (J=0; J<=M; J++) {
         W[0][J] = functnG(X[0],Y[J]);
         W[N][J] = functnG(X[N],Y[J]);
      }  
      for (I=1; I<=N1; I++) 
         for (J=1; J<=M1; J++) W[I][J] = 0.0;
      /* STEP 5 */
      /* use V for lambda, VV for mu */
      V = H * H / ( K * K );
      VV = 2.0 * ( 1.0 + V );
      L = 1;
      OK = false;
      /* Z is a new value of W(I,J) to be used in computing
         the norm of the error E used in place of NORM */
      /* STEP 6 */
      while ((L <= NN) && (!OK)) {
         /* STEPS 7 through 20 perform Gauss-Seidel iterations */
         /* STEP 7 */
         Z = (-H*H*functnF(X[1],Y[M1])+functnG(A,Y[M1])+V*
              functnG(X[1],D)+V*W[1][M2]+W[2][M1])/VV;
         E = Math.abs( W[1][M1] - Z );
         W[1][M1] = Z;
         /* STEP 8 */
         for (I=2; I<=N2; I++) {
            Z = (-H*H*functnF(X[I],Y[M1])+V*functnG(X[I],D)+
                 W[I-1][M1]+W[I+1][M1]+V*W[I][M2])/VV;
            if ( Math.abs( W[I][M1] - Z ) > E ) 
               E = Math.abs( W[I][M1] - Z );
            W[I][M1] = Z;
         }  
         /* STEP 9 */
         Z = (-H*H*functnF(X[N1],Y[M1])+functnG(B,Y[M1])+V*
              functnG(X[N1],D)+W[N2][M1]+V*W[N1][M2])/VV;
         if ( Math.abs( W[N1][M1] - Z ) > E ) 
            E = Math.abs( W[N1][M1] - Z );
         W[N1][M1] = Z;
         /* STEP 10 */
         for (LL=2; LL<=M2; LL++) {
            J = M2 - LL + 2; 
            /* STEP 11 */
            Z = (-H*H*functnF(X[1],Y[J])+functnG(A,Y[J])+
                V*W[1][J+1]+V*W[1][J-1]+W[2][J])/VV;
            if ( Math.abs( W[1][J] - Z ) > E ) 
               E = Math.abs( W[1][J] - Z );
            W[1][J] = Z;
            /* STEP 12 */
            for (I=2; I<=N2; I++) {
               Z = (-H*H*functnF(X[I],Y[J])+W[I-1][J]+
                   V*W[I][J+1]+V*W[I][J-1]+W[I+1][J])/VV;
               if ( Math.abs( W[I][J] - Z ) > E ) 
                  E = Math.abs( W[I][J] - Z );
               W[I][J] = Z;
            }  
            /* STEP 13 */
            Z = (-H*H*functnF(X[N1],Y[J])+functnG(B,Y[J])+
                 W[N2][J]+V*W[N1][J+1]+V*W[N1][J-1])/VV;
            if ( Math.abs( W[N1][J] - Z ) > E )
               E = Math.abs( W[N1][J] - Z );
            W[N1][J] = Z;
         }  
         /* STEP 14 */
         Z = ( -H * H * functnF( X[1],Y[1] ) + V * functnG( X[1], C ) +
              functnG( A, Y[1] ) + V * W[1][2] + W[2][1] ) / VV;
         if ( Math.abs( W[1][1] - Z ) > E ) 
            E = Math.abs( W[1][1] - Z );
         W[1][1] = Z;
         /* STEP 15 */
         for (I=2; I<=N2; I++) {
            Z = (-H*H*functnF(X[I],Y[1])+V*functnG(X[I],C)+
                 W[I+1][1]+W[I-1][1]+V*W[I][2])/VV;
            if ( Math.abs( W[I][1] - Z ) > E )
               E = Math.abs( W[I][1] - Z );
            W[I][1] = Z;
         }  
         /* STEP 16 */
         Z = (-H*H*functnF(X[N1],Y[1])+V*functnG(X[N1],C)+
              functnG(B,Y[1])+W[N2][1]+V*W[N1][2])/VV;
         if ( Math.abs( W[N1][1] - Z ) > E ) 
            E = Math.abs( W[N1][1] - Z );
         W[N1][1] = Z;
         /* STEP 17 */
         if (E<=TOL) {
            /* STEP 18 */ 
            OUTPUT();
            /* STEP 19 */
            OK = true;
         }  
         else 
            /* STEP 20 */
            L++;
      }  
      /* STEP 21 */
      if (L > NN) 
         solution.append("Method fails after iteration number "+ NN +"\n");
             
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
		myParser.addVariable("y", yValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2)
   {
    double f;
    xValue = point1;
    yValue = point2;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
  public double functnG(double point1, double point2)
   {
    double g;
    xValue = point1;
    yValue = point2;  
    parseExp(exprField2.getText());
    g = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return g;
   }


 public void OUTPUT()
   {
      solution.append("Poissson Equation Finite-Difference Method\n\n");
      solution.append(" I\tJ\tX(I)\tY(I)\tW(I,J)\n");
     for(I=1; I<=N1; I++)
       for(J=1; J<=M1; J++)
         solution.append(""+I+"\t"+J+"\t"+formatter.format(X[I])+"\t"+formatter.format(Y[J])+"\t"+formatter.format(W[I][J])+"\n");
         solution.append("Convergence occurred on iteration number "+L+"\n");
   }      
 

  public boolean inputCheck()
   {
        String errorInfo;
          if ((A >= B )||(C >= D)){
            solution.append("Left endpoint must be less than right endpoint \n");
            OK = false;}

          if ((N <=2) || (M <=2) ){
            solution.append("Numbers M and N must exceed 2 \n");
            OK = false;}
          
          if (TOL <= 0){
            solution.append("Tolerance must be positive \n");
            OK = false;}

          if (NN <= 0){
            solution.append("Number of iterations must be a positive integer\n");
            OK = false;}

          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    endPointC = new JTextField(4);
    endPointD = new JTextField(4);
    intM = new JTextField(2);
    intN = new JTextField(2);
    exprField = new JTextField(20);
    exprField2 = new JTextField(20);
    iterations = new JTextField(4);
    tolerance = new JTextField(6);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(6,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function F(x,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("x*e^y");
    inputPanel.add(new JLabel("Function G(x,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("x*e^y");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("Intervals N =:", JLabel.RIGHT));
    inputPanel.add(intN);

    inputPanel.add(new JLabel(" C =:", JLabel.RIGHT));
    inputPanel.add(endPointC);
    inputPanel.add(new JLabel(" D =:", JLabel.RIGHT));
    inputPanel.add(endPointD);
    inputPanel.add(new JLabel("Intervals M =:", JLabel.RIGHT));
    inputPanel.add(intM);


    inputPanel.add(new JLabel(" Iterations:", JLabel.RIGHT));
    inputPanel.add(iterations);
    inputPanel.add(new JLabel(" TOL :", JLabel.RIGHT));
    inputPanel.add(tolerance);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }


  }
    
   
