
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class PieceW
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField arrayX, integerN, exprField, exprField2, exprField3;
  private JTextArea solution;
  private double X[], Y[], H[], A[], B[], C[], ALPHA[], BETA[], ZETA[], Z[];
  private double Q[][], HQ, HC;
  private int N1, J1, FN, N, J;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue, pi;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                // pi = Math.PI;
                 A = new double[25]; Y = new double[27];
                 X = new double[27]; H = new double[27]; B = new double[25]; 
                 ALPHA = new double[25]; BETA = new double[25]; ZETA = new double[25];
                 Z = new double[25]; C = new double[25]; Q = new double[6][26];
                 N = Integer.parseInt(integerN.getText());
                 toArray(arrayX.getText(), Y);
                 for(J = 1; J<=N; J++) X[J] = Y[J-1];
                 X[0]=0; X[N+1]=1;
                 for(J = 1; J<=N; J++) H[J-1] = X[J] - X[J-1]; H[N] = X[N+1] - X[N];
                OK  = true; 


            if(inputCheck()){
            solution.setText("");
       /* STEP 1 */
       N1 = N - 1;
      /* STEP 3 */
      for (J=1; J<=N1; J++) {
         Q[0][J-1] = SIMPSON( 1, X[J], X[J+1] ) / (( H[J] ) * ( H[J] ));
         Q[1][J-1] = SIMPSON( 2, X[J-1], X[J] ) / (( H[J-1] ) * ( H[J-1] ));
         Q[2][J-1] = SIMPSON( 3, X[J], X[J+1] ) / (( H[J] ) * ( H[J] ));
         Q[3][J-1] = SIMPSON( 4, X[J-1], X[J] ) / (( H[J-1] ) * ( H[J-1] ));
         Q[4][J-1] = SIMPSON( 5, X[J-1], X[J] ) / H[J-1] ;
         Q[5][J-1] = SIMPSON( 6, X[J], X[J+1] ) / H[J];
      }  
      Q[1][N-1] = SIMPSON( 2, X[N-1], X[N] ) / (( H[N-1] ) * ( H[N-1] ));
      Q[2][N-1] = SIMPSON( 3, X[N], X[N+1] ) / (( H[N] ) * ( H[N] ));
      Q[3][N-1] = SIMPSON( 4, X[N-1], X[N] ) / (( H[N-1] ) * ( H[N-1] ));
      Q[3][N] = SIMPSON( 4, X[N], X[N+1] ) / (( H[N] ) * ( H[N] ));
      Q[4][N-1] = SIMPSON( 5, X[N-1], X[N] ) / H[N-1];
      Q[5][N-1] = SIMPSON( 6, X[N], X[N+1] ) / H[N];
      /* STEP 4 */
      for (J=1; J<=N1; J++) {
         ALPHA[J-1] = Q[3][J-1]+Q[3][J]+Q[1][J-1]+Q[2][J-1];
         BETA[J-1] = Q[0][J-1]-Q[3][J];
         B[J-1] = Q[4][J-1]+Q[5][J-1];
      }  
      /* STEP 5 */
      ALPHA[N-1] = Q[3][N-1]+Q[3][N]+Q[1][N-1]+Q[2][N-1];
      B[N-1] = Q[4][N-1]+Q[5][N-1];
      /* STEPS 6-10 solve a symmtric tridiagonal linear system using
         Algorithm 6.7.  */
      /* STEP 6 */
      A[0] = ALPHA[0];
      ZETA[0] = BETA[0] / ALPHA[0];
      Z[0] = B[0] / A[0];
      /* STEP 7 */ 
      for (J=2; J<=N1; J++) {
         A[J-1] = ALPHA[J-1] - BETA[J-2] * ZETA[J-2];
         ZETA[J-1] = BETA[J-1] / A[J-1];
         Z[J-1] = (B[J-1]-BETA[J-2]*Z[J-2])/A[J-1];
      }  
      /* STEP 8 */
      if ( N > 1) {
      A[N-1] = ALPHA[N-1] - BETA[N-2] * ZETA[N-2];
      Z[N-1] = (B[N-1]-BETA[N-2]*Z[N-2])/A[N-1];
      }
      /* STEP 9 */
      C[N-1] = Z[N-1];   
      for (J=1; J<=N1; J++) {
         J1 = N - J;
         C[J1-1] = Z[J1-1] - ZETA[J1-1] * C[J1];
      }
      output();
  
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnP(double point)
   {
    double p;
    xValue = point;
    parseExp(exprField.getText());
    p = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return p;
   }
  
  public double functnQQ(double point)
   {
    double qq;
    xValue = point;
    parseExp(exprField2.getText());
    qq = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return qq;
   }

  public double functnF(double point)
   {
    double f;
    xValue = point;
    parseExp(exprField3.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }

//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************


  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i= 0; i< charArray.length; i++)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }

public double SIMPSON(int FN, double A, double B)
{ 
   double Z[];
   Z = new double[5];
   double Y,H,simpson; 
   int I;
  
   H = (B - A) / 4.0;
   for (I=0; I<=4; I++) {
      Y = A + I * H;
      switch (FN) {
         case 1:
            Z[I] = ( 4.0 - I ) * I * H * H * functnQQ( Y ); 
            break;
         case 2:
            Z[I] = ( I * H ) * ( I * H ) * functnQQ( Y );
            break;
         case 3:
            Z[I] = ( H * ( 4.0 - I ) ) * ( H * ( 4.0 - I ) ) * functnQQ( Y );
            break;
         case 4:
            Z[I] = functnP( Y );
            break;
         case 5:
            Z[I] = I * H * functnF( Y );
            break;
         case 6:
            Z[I] = ( 4.0 - I ) * H * functnF( Y );
            break;
      }  
   }
   simpson = ( Z[0] + Z[4] + 2.0 * Z[2] + 4.0 * ( Z[1] + Z[3] ) ) * H / 3.0;
   return simpson;
}  

   public void output(){
        solution.append("PieceWise Linear Rayleigh-Ritz Method\n\n");
        solution.append(" I\tX(I-1)\tX(I)\tX(I+1)\tC(I)\n");
        for(J = 1; J <= N; J++)
          solution.append(" "+J+"\t"+X[J-1]+"\t"+X[J]+"\t"+X[J+1]+"\t"+formatter.format(C[J-1])+"\n");
    }



  public boolean inputCheck()
   {
        String errorInfo;
          if (N <=0 ){
            solution.append("N must be positive \n");
            OK = false;}
          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField3.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    integerN = new JTextField(2);
    exprField = new JTextField(20);
    arrayX = new JTextField(20);
    exprField2 = new JTextField(20);
    exprField3 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(4,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function P(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("1");
    inputPanel.add(new JLabel("Function Q(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("pi^2");
    inputPanel.add(new JLabel("Function F(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField3); exprField3.setText("2*pi^2*sin(pi*x)");

    inputPanel.add(new JLabel(" N =:", JLabel.RIGHT));
    inputPanel.add(integerN);
    inputPanel.add(new JLabel(" mesh points Xi :", JLabel.RIGHT));
    inputPanel.add(arrayX);arrayX.setText(".1,.2,.3,.4,.5,.6,.7,.8,.9");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
