import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class Pades
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField lnInt, lmInt, matAField;
  private JTextArea solution;
  private int PP,FLAG,N,M,I,NN,IMAX,J,JJ,IP,JP,NCOPY,I1,J1,N1,K,N2,LL,KK; 
  private int LM,LN,BN;
  private int NROW[];
  private boolean OK;
  private NumberFormat formatter;
  private double A[][], AA[], P[], Q[], AMAX, XM, SUM;
  

  public void init() {
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[10][11]; AA = new double[11]; P = new double[7];
                Q = new double[7]; NROW = new int[10];
                LN = Integer.parseInt(lnInt.getText());
                LM = Integer.parseInt(lmInt.getText());
                BN = LN + LM ;
                OK = true;

                toArray(matAField.getText(), AA);

           if(inputCheck())
             {
            solution.setText("");       
      /* STEP 1 */
      N = BN;
      M = N + 1;
      /* STEP 2  -  performed in input */
      for (I=1; I<=N; I++) NROW[I-1] = I;
      /* initialize row pointer for linear system */
      NN = N - 1;
      /* STEP 3 */
      Q[0] = 1.0;
      P[0] = AA[0];
      /* STEP 4 */
      /* Set up a linear system, but use A[i,j] instead of B[i,j]. */
      for (I=1; I<=N; I++) {
         /* STEP 5 */
         for (J=1; J<=I-1; J++) 
             if (J <= LN) A[I-1][J-1] = 0.0;
         /* STEP 6 */
         if (I <= LN) A[I-1][I-1] = 1.0;
         /* STEP 7 */
         for (J=I+1; J<=N; J++) A[I-1][J-1] = 0.0;
         /* STEP 8 */
         for (J=1; J<=I; J++) 
            if  (J <= LM) A[I-1][LN+J-1] = -AA[I-J];
         /* STEP 9 */
         for (J=LN+I+1; J<=N; J++) A[I-1][J-1] = 0.0;
         /* STEP 10 */
         A[I-1][N] = AA[I];
      }  
      /* Solve the linear system using partial pivoting. */
      I = LN+1;
      /* STEP 11 */
      while (OK && (I <= NN)) {
         /* STEP 12 */
         IMAX = NROW[I-1];
         AMAX = Math.abs(A[IMAX-1][I-1]);
         IMAX = I;
         JJ = I + 1;
         for (IP=JJ; IP<=N; IP++) {
            JP = NROW[IP-1];
            if (Math.abs(A[JP-1][I-1]) > AMAX) {
               AMAX = Math.abs(A[JP-1][I-1]);
               IMAX = IP;
            }  
         }  
         /* STEP 13 */
         if (AMAX <= 1.0E-20) OK = false;
         else {
            /* STEP 14 */
            /* simulate row interchange */
            if (NROW[I-1] != NROW[IMAX-1]) {
               NCOPY = NROW[I-1];
               NROW[I-1] = NROW[IMAX-1];
               NROW[IMAX-1] = NCOPY;
            }  
            I1 = NROW[I-1];
            /* STEP 15 */
            /* Perform elimination. */
            for (J=JJ; J< M; J++) {
               J1 = NROW[J-1];
               /* STEP 16 */
               XM = A[J1-1][I-1] / A[I1-1][I-1];
               /* STEP 17 */
               for (K=JJ; K<=M; K++) 
                  A[J1-1][K-1] = A[J1-1][K-1] - XM * A[I1-1][K-1];
               /* STEP 18 */
               A[J1-1][I-1] = 0.0;
            }  
         }  
         I++;
      }  
      if (OK) {
         /* STEP 19 */
         N1 = NROW[N-1];                              
         if (Math.abs(A[N1-1][N-1]) <= 0) OK = false;
         /* system has no unique solution */
         else {
            /* STEP 20 */
            /* Start backward substitution. */
            if (LM > 0) {
               Q[LM] = A[N1-1][M-1] / A[N1-1][N-1];
               A[N1-1][M-1] = Q[LM];
            }
            PP = 1;
            /* STEP 21 */
            for (K=LN+1; K<=NN; K++) {
               I = NN - K + LN+1;
               JJ = I + 1;
               N2 = NROW[I-1];
               SUM = A[N2-1][N];
               for (KK=JJ; KK<=N; KK++) {
                  LL = NROW[KK-1];
                  SUM = SUM - A[N2-1][KK-1] * A[LL-1][M-1];
               }  
               A[N2-1][M-1] = SUM / A[N2-1][I-1];
               Q[LM-PP] = A[N2-1][M-1];
               PP++;
            }
            /* STEP 22 */
            for (K=1; K<=LN; K++) {
               I = LN - K + 1;
               N2 = NROW[I-1];
               SUM = A[N2-1][N];
               for (KK=LN+1; KK<=N; KK++) {
                  LL = NROW[KK-1];
                  SUM = SUM - A[N2-1][KK-1] * A[LL-1][M-1];
               }
               A[N2-1][M-1] = SUM;
               P[LN-K+1] = A[N2-1][M-1];
            }
            /* STEP 23 */
            /* procedure completed successfully */
            outPut(Q, P, LN, LM);
           }  
      }
      if (!OK) solution.append("System has no unique solution\n");
      }
}


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************

   public void outPut(double Q[], double P[],int LN,int LM)
       {
        int I;
        solution.append("Pade Rational Approximation\n\n");
        solution.append("Denominator Coefficients Q[0], Q[1], ..., Q[m]\n");
        for (I=0; I<=LM; I++) solution.append(""+formatter.format(Q[I])+"    ");
        solution.append("\n\n");
        solution.append("Numerator Coefficients P[0], P[1], ..., P[n]\n");
        for (I=0; I<=LN; I++) solution.append(""+formatter.format(P[I])+"    ");
        solution.append("\n\n");

        }


  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,",");  
    for(int i= 0; i< charArray.length; i++)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }


  public boolean inputCheck()
   {
   
      if ((LN < 0 )||(LM < 0)){
         solution.append("m and n must be a positive integer. \n");
          OK = false;}
          if ((LN == 0 )&&(LM == 0 )){
            solution.append("Not both m and n can be zero. \n");
          OK = false;}

         return OK;
   }     



  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    lnInt = new JTextField(2);
    lmInt = new JTextField(2);
    matAField = new JTextField(40);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(2,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("m =:", JLabel.RIGHT));
    inputPanel.add(lmInt);
    inputPanel.add(new JLabel("n =:", JLabel.RIGHT));
    inputPanel.add(lnInt);

    JPanel inputPanel2 = new JPanel(new GridLayout(2,2));

    inputPanel2.add(new JLabel("A(i) in row form. Separate elements with commas \",\" A =:", JLabel.RIGHT));
    inputPanel2.add(matAField); matAField.setText("1,-1,.5,-.166666666,.041666666,-.008333333,.001388888");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(8);
    formatter.setMinimumFractionDigits(8);
  }


  }
    
   
