
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class NonLineFD
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, alphaCon, betaCon, integerN, integerM;
  private JTextField exprField, exprField2, exprField3, tolerance;
  private JTextArea solution;
  private double W[], A[], B[], C[], D[], L[], U[], Z[], V[];
  private double AA, BB, ALPHA, BETA, X, H, T, TOL, VMAX;
  private int I, N, N1, NN, K, J;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue, yValue, zValue;


  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 W = new double[25]; A = new double[25]; B = new double[25];
                 C = new double[25]; D = new double[25]; L = new double[25]; 
                 U = new double[25]; Z = new double[25]; V = new double[25];

                 AA = Double.parseDouble(endPointA.getText());
                 BB = Double.parseDouble(endPointB.getText());
                 ALPHA = Double.parseDouble(alphaCon.getText());
                 BETA = Double.parseDouble(betaCon.getText());
                 N = Integer.parseInt(integerN.getText());
                 NN = Integer.parseInt(integerM.getText());
               TOL = Double.parseDouble(tolerance.getText());

                OK  = true; 

    if(inputCheck()){
            solution.setText("");
            solution.append("Non-Linear Finite-Difference Method\n\n");             
            solution.append("I\tX(I)\tW(I)\n");
      /* STEP 1 */
      N1 = N - 1;
      H = (BB - AA) / (N + 1);
      /* STEP 2 */
      for (I=1; I<=N; I++) W[I-1] = ALPHA+I*H*(BETA-ALPHA)/(BB-AA);
      /* STEP 3 */
      K = 1;
      /* STEP 4 */
      while ((K <= NN) && OK) { 
         /* STEP 5 */
         X = AA + H;
         T = ( W[1] - ALPHA ) / ( 2.0 * H );
         A[0] = 2.0 + H * H * functnFY( X, W[0], T );
         B[0] = -1.0 + H * functnFYP( X, W[0], T ) / 2.0;
         D[0] = -( 2.0 * W[0] - W[1] - ALPHA + H * H * functnF( X, W[0], T ) );
         /* STEP 6 */
         for (I=2; I<=N1; I++) {
            X = AA + I * H;
            T = ( W[I] - W[I-2] ) / ( 2.0 * H );
            A[I-1] = 2.0 + H * H * functnFY( X, W[I-1], T );
            B[I-1] = -1.0 + H * functnFYP( X, W[I-1], T ) / 2.0;
            C[I-1] = -1.0 - H * functnFYP( X, W[I-1], T ) / 2.0;
            D[I-1] = -(2.0*W[I-1]-W[I]-W[I-2]+H*H*functnF( X, W[I-1], T ) );
         }  
         /* STEP 7 */
         X = BB - H;
         T = ( BETA - W[N-2] ) / ( 2.0 * H );
         A[N-1] = 2.0 + H * H * functnFY( X, W[N-1], T );
         C[N-1] = -1.0 - H * functnFYP( X, W[N-1], T ) / 2.0;
         D[N-1] = -( 2.0 * W[N-1] - W[N-2] - BETA + H * H * functnF(X, W[N-1], T) );
         /* STEP 8 */
         /* STEPS 8 through 12 solve a tridiagonal linear system
            using Algorithm 6.7 */
         L[0] = A[0];
         U[0] = B[0] / A[0];
         Z[0] = D[0] / L[0];
         /* STEP 9 */
         for (I=2; I<=N1; I++) {
            L[I-1] = A[I-1] - C[I-1] * U[I-2];
            U[I-1] = B[I-1] / L[I-1];
            Z[I-1] = (D[I-1]-C[I-1]*Z[I-2])/L[I-1];
         }  
         /* STEP 10 */
         L[N-1] = A[N-1] - C[N-1] * U[N-2];
         Z[N-1] = (D[N-1]-C[N-1]*Z[N-2])/L[N-1];
         /* STEP 11 */
         V[N-1] = Z[N-1];
         VMAX = Math.abs(V[N-1]);
         W[N-1] = W[N-1] + V[N-1];
         /* STEP 12 */
         for (J=1; J<=N1; J++) {
            I = N - J;
            V[I-1] = Z[I-1] - U[I-1] * V[I];
            W[I-1] = W[I-1] + V[I-1];
            if (Math.abs(V[I-1]) > VMAX) VMAX = Math.abs(V[I-1]);
         }  
         /* STEP 13 */
         /* test for accuracy */
         if (VMAX <= TOL) {
            I = 0;
         solution.append(" "+ I +"\t" +formatter.format(AA)+"\t"+ formatter.format(ALPHA)+"\n");
            for (I=1; I<=N; I++) {
               X = AA + I * H;
               solution.append(" "+ I +"\t" +formatter.format(X)+"\t"+ formatter.format(W[I-1])+"\n");
            }  
            I = N + 1;
              solution.append(" "+ I +"\t" +formatter.format(BB)+"\t"+ formatter.format(BETA)+"\n");
               OK = false;
         }  
         else 
            /* STEP 18 */
            K++;
      }  
      /* STEP 19 */ 
      if (K > NN) 

        solution.append("No convergence in "+NN+" iterations\n");
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
		myParser.addVariable("y", yValue);
		myParser.addVariable("z", zValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2, double point3)
   {
    double f;
    xValue = point1;
    yValue = point2;
    zValue = point3;
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
  public double functnFY(double point1, double point2, double point3)
   {
    double fy;
    xValue = point1;
    yValue = point2;
    zValue = point3;
    parseExp(exprField2.getText());
    fy = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return fy;
   }

  public double functnFYP(double point1, double point2, double point3)
   {
    double fyp;
    xValue = point1;
    yValue = point2;
    zValue = point3;

    parseExp(exprField3.getText());
    fyp = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return fyp;
   }


  public boolean inputCheck()
   {
        String errorInfo;
          if (AA >= BB ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (N <=1 ){
            solution.append("Number of subinterals N must exceed 1.\n");
            OK = false;}
          if (NN <=0 ){
            solution.append("Number of Iterations M must be positive Integer\n");
            OK = false;}

          if (TOL <=0 ){
            solution.append("Tolerance must be positive number\n");
            OK = false;}

          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField3.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    alphaCon = new JTextField(4);
    betaCon = new JTextField(4);
    integerN = new JTextField(2);
    integerM = new JTextField(2);
    tolerance = new JTextField(8);
    exprField = new JTextField(20);
    exprField2 = new JTextField(20);
    exprField3 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(6,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function F(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("(32+2*x^3 -y*z)/8");
    inputPanel.add(new JLabel("Function FY(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("-z/8");
    inputPanel.add(new JLabel("Function FYP(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(exprField3); exprField3.setText("-y/8");

    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" Alpha Y(A) =:", JLabel.RIGHT));
    inputPanel.add(alphaCon);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel(" Beta Y(B) =:", JLabel.RIGHT));
    inputPanel.add(betaCon);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel(" N =:", JLabel.RIGHT));
    inputPanel.add(integerN);
    inputPanel.add(new JLabel(" M =:", JLabel.RIGHT));
    inputPanel.add(integerM);
    inputPanel.add(new JLabel(" TOL =:", JLabel.RIGHT));
    inputPanel.add(tolerance);

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
