
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class NonLine
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, alphaCon, betaCon, integerN, integerM;
  private JTextField exprField, exprField2, exprField3, tolerance;
  private JTextArea solution;
  private double T, A, B, ALPHA, BETA, X, H, TK, U1, U2, TOL;
  private double K11, K12, K21, K22, K31, K32, K41, K42;
  private int I, N, NN, K, J;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue, yValue, zValue;
  private double W1[], W2[];

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 W1 = new double[26]; 
                 W2 = new double[26];

                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 ALPHA = Double.parseDouble(alphaCon.getText());
                 BETA = Double.parseDouble(betaCon.getText());
                 N = Integer.parseInt(integerN.getText());
                 NN = Integer.parseInt(integerM.getText());
               TOL = Double.parseDouble(tolerance.getText());
                OK  = true; 

    if(inputCheck()){
            solution.setText("");
            solution.append("Non-Linear Shooting Method\n\n");             
            solution.append(" I\tX(I)\tW1(I)\tW2(I)\n");
          H = (B - A) / N;
          K = 1;
         TK = (BETA - ALPHA)/(B - A);      /*  TK already computed.   */
         OK = false;
      /* STEP 2 */
      while ((K <= NN) && !OK) {
         /* STEP 3 */
         W1[0] = ALPHA;
         W2[0] = TK;
         U1 = 0.0 ;
         U2 = 1.0;
         /* STEP 4 */
         /* Runge-Kutta method for systems is used in STEPS 5, 6 */
         for (I=1; I<=N; I++) {
            /* STEP 5 */
            X = A + ( I - 1.0 ) * H;
            T = X + 0.5 * H;
            /* STEP 6 */
            K11 = H * W2[I-1];
            K12 = H * functnF( X, W1[I-1], W2[I-1] );
            K21 = H * ( W2[I-1] + 0.5 * K12 );
            K22 = H * functnF( T, W1[I-1] + 0.5 * K11, W2[I-1] +
                   0.5 * K12);
            K31 = H * ( W2[I-1] + 0.5 * K22 );
            K32 = H * functnF( T, W1[I-1] + 0.5 * K21, W2[I-1] +
                   0.5 * K22 );
            K41 = H * ( W2[I-1] + K32 );
            K42 = H * functnF( X + H, W1[I-1] + K31, W2[I-1] + K32 );
            W1[I] = W1[I-1] + ( K11 + 2.0 * ( K21 + K31 ) +
                       K41 ) / 6.0;
            W2[I] = W2[I-1] + ( K12 + 2.0 * ( K22 + K32 ) +
                       K42 ) / 6.0;
            K11 = H * U2;
            K12 = H * ( functnFY( X, W1[I-1], W2[I-1] ) * U1 +
                   functnFYP( X, W1[I-1], W2[I-1] ) * U2 );
            K21 = H * ( U2 + 0.5 * K12 );
            K22 = H*(functnFY(T,W1[I-1],W2[I-1])*
                   (U1+0.5*K11)+functnFYP(T,W1[I-1],W2[I-1])*
                   (U2+0.5*K21));
            K31 = H * ( U2 + 0.5 * K22 );
            K32 = H * ( functnFY( T, W1[I-1], W2[I-1] ) *
                   (U1+0.5*K21) + functnFYP(T,W1[I-1],W2[I-1])*
                   (U2+0.5*K22));
            K41 = H * ( U2 + K32 );
            K42 = H*(functnFY(X+H,W1[I-1],W2[I-1])*(U1+K31)+
                   functnFYP(X+H,W1[I-1],W2[I-1])*(U2+K32));
            U1 = U1+(K11+2.0*(K21+K31)+K41)/6.0;
            U2 = U2+(K12+2.0*(K22+K32)+K42)/6.0;
         }  
         /* STEP 7 */
         /* test for accuracy */
         if (Math.abs(W1[N] - BETA) < TOL) {
            /* STEP 8 */
            I = 0;
            solution.append(" "+ I +"\t" +formatter.format(A)+"\t"+ formatter.format(ALPHA)+"\t"+
                             formatter.format(TK)+"\n");
            for (I=1; I<=N; I++) {
               J = I + 1;
               X = A + I * H;
               solution.append(" "+ I +"\t" +formatter.format(X)+"\t"+ formatter.format(W1[J-1])+"\t"+
                                  formatter.format(W2[J-1])+"\n");
               }  
                solution.append( "Convergence in "+ K+" iterations\n");
                solution.append( " t = "+ TK+"\n");
             /* STEP 9 */
             OK = true;
          }  
         else {
            /* STEP 10 */
            /* Newton's method applied to improve TK */
            TK = TK - ( W1[N] - BETA ) / U1;
            K = K + 1;
         }  
      }   
      /* STEP 11 */  
      /* method failed */
      if (!OK)   solution.append("Method failed after "+NN+"\n");
    
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


    public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
		myParser.addVariable("y", yValue);
		myParser.addVariable("z", zValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2, double point3)
   {
    double f;
    xValue = point1;
    yValue = point2;
    zValue = point3;
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
  public double functnFY(double point1, double point2, double point3)
   {
    double fy;
    xValue = point1;
    yValue = point2;
    zValue = point3;
    parseExp(exprField2.getText());
    fy = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return fy;
   }

  public double functnFYP(double point1, double point2, double point3)
   {
    double fyp;
    xValue = point1;
    yValue = point2;
    zValue = point3;

    parseExp(exprField3.getText());
    fyp = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return fyp;
   }


  public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (N <= 1 ){
            solution.append("Number of subinterals N must exceed 1.\n");
            OK = false;}
          if (NN <=0 ){
            solution.append("Number of Iterations M must be positive Integer\n");
            OK = false;}

          if (TOL <=0 ){
            solution.append("Tolerance must be positive number\n");
            OK = false;}

          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          parseExp(exprField3.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    alphaCon = new JTextField(4);
    betaCon = new JTextField(4);
    integerN = new JTextField(2);
    integerM = new JTextField(2);
    tolerance = new JTextField(8);
    exprField = new JTextField(20);
    exprField2 = new JTextField(20);
    exprField3 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(6,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function F(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("(32+2*x^3 -y*z)/8");
    inputPanel.add(new JLabel("Function FY(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(exprField2); exprField2.setText("-z/8");
    inputPanel.add(new JLabel("Function FYP(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(exprField3); exprField3.setText("-y/8");

    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" Alpha Y(A) =:", JLabel.RIGHT));
    inputPanel.add(alphaCon);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel(" Beta Y(B) =:", JLabel.RIGHT));
    inputPanel.add(betaCon);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel(" N =:", JLabel.RIGHT));
    inputPanel.add(integerN);
    inputPanel.add(new JLabel(" M =:", JLabel.RIGHT));
    inputPanel.add(integerM);
    inputPanel.add(new JLabel(" TOL =:", JLabel.RIGHT));
    inputPanel.add(tolerance);

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
