
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Newtons
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField midPoint, point0, tTolerance, nIteration, exprField1, exprField2;
  private JTextArea solution;
  private double p0,f0, d, fp0, TOL;
  private int I, iterations;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;


  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 p0 = Double.parseDouble(point0.getText());
                TOL = Double.parseDouble(tTolerance.getText());
         iterations = Integer.parseInt(nIteration.getText());
                OK  = true; 
            solution.setText("");             

            if(inputCheck()){ I= 1;
               f0 =functnF(p0);
            solution.append("  "+"I\tP0\tF0\n");  
            solution.append("====================================================\n");       
       while(I<=iterations && OK){

               fp0=functnFp(p0);
                d =f0/fp0;
               p0 = p0 - d;
               f0 =functnF(p0);               
               solution.append(" "+ I  +"\t"+ formatter.format(p0) +"\t"+formatter.format(f0)+"\n");       
            if (absVal(d)< TOL)
               {
                solution.append("No of Iterations "+I+" \n");
                solution.append("Approximate solution "+formatter.format(p0)+" \n");
                solution.append("with F(p) = "+formatter.format(f0)+" \n");
                solution.append("Tolerance "+ TOL);

                OK = false;}
            else{
                  I++; 
                    }

           }
        if (OK){
          solution.append("No of Iterations "+nIteration.getText()+" \n");
          solution.append("gave approximation "+formatter.format(p0)+" \n");
          solution.append("with F(p) = "+formatter.format(f0)+" \n");
          solution.append("not within tolerance "+ TOL);}
          }
         }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
   public void parseExpression() {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);

	}


  public double functnF(double point)
   {
    double f;
    parseExpression();
    xValue = point;  
    parseExpression();
    myParser.parseExpression(exprField1.getText());
    f = myParser.getValue();  // example   f = (x + 4.0)*x^2 - 10.0;
    return f;
   }
  
  public double functnFp(double point)
   {
    double fp;
    xValue = point;  
    parseExpression();
    myParser.parseExpression(exprField2.getText());
    fp = myParser.getValue();  // example   f = (x + 4.0)*x^2 - 10.0;
    return fp;
   }

  public boolean inputCheck()
   {
        String errorInfo;
          if (TOL <= 0.0){
            solution.append("Tolerance must be positive \n");
            OK = false;}
          if (iterations <= 0 ){
            solution.append("Number of Iterations must be positive Integer\n");
            OK = false;}
            parseExpression();
            myParser.parseExpression(exprField1.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
            parseExpression();
            myParser.parseExpression(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 public double absVal(double val)
  { 
    if( val >= 0) return val;
    else return -val;
  }  
 
   public void setVisualComponent()
    {
    startButton = new JButton("Start");
    point0 = new JTextField(4);

    tTolerance = new JTextField(6);
    nIteration = new JTextField(2);
    exprField1 = new JTextField("cos(x) - x");
    exprField2 = new JTextField("-sin(x) - 1");
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    
    JPanel inputPanel1 = new JPanel(new GridLayout(4,4));

    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel1.add(new JLabel("Function f(x) =:", JLabel.RIGHT));
    inputPanel1.add(exprField1); 
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel1.add(new JLabel("Derivative fp(x) =:", JLabel.RIGHT));
    inputPanel1.add(exprField2); 
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));

    JPanel inputPanel2 = new JPanel(new GridLayout(2,6));

    inputPanel2.add(new JLabel("Point Po:", JLabel.RIGHT));
    inputPanel2.add(point0);
    inputPanel2.add(new JLabel("TOL:", JLabel.RIGHT));
    inputPanel2.add(tTolerance);
    inputPanel2.add(new JLabel("No Iterations:", JLabel.RIGHT));
    inputPanel2.add(nIteration);

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputAreaPanel = new JPanel(new BorderLayout());
    inputAreaPanel.add(inputPanel1, "North");
    inputAreaPanel.add(inputPanel2, "South");

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputAreaPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);

      }


  }
    
   
