
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class NewtonSy
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField approxX, approxY, approxZ, intNN, intN, tolerance, expr1, expr2,expr3;
  private JTextField expr4, expr5, expr6, expr7, expr8, expr9, expr10, expr11, expr12;
  private JTextArea solution;
  private double A[][], X[], Y[]; 
  private double TOL, R;
  private int N, NN, I, J, K, FLAG;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue, yValue, zValue;

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = new double[10][11]; X = new double[10]; Y = new double[10];
                 TOL = Double.parseDouble(tolerance.getText());
                 N = Integer.parseInt(intN.getText());
                 NN = Integer.parseInt(intNN.getText());
                 X[0] = Double.parseDouble(approxX.getText());
                 X[1] = Double.parseDouble(approxY.getText());
                 X[2] = Double.parseDouble(approxZ.getText());
                 OK  = true; 
                 solution.setText("");             
                 FLAG = 2;
                 
            if(inputCheck()){
                 solution.setText("");
                 solution.append("Newtons Method for NonLinear System.\n\n");
                 if(N==3) solution.append("Iteration\tX\tY\tZ\tError\n");             
                 else solution.append("Iteration\tX\tY\tError\n");             
      /* STEP 1 */
      K = 1;
      /* STEP 2 */
      while (OK && (K <= NN)) {
         /* STEP 3 */
         for (I=1; I<=N; I++) {
            for (J=1; J<=N; J++) A[I-1][J-1] = functnP(I, J);
            A[I-1][N] = -functnF(I);
         }  
         /* STEP 4 */
         LINSYS();
         if (OK) {
            /* STEP 5 */
            R = 0.0;
            for (I=1; I<=N; I++) {
               if (Math.abs(Y[I-1]) > R) R = Math.abs(Y[I-1]);
               X[I-1] = X[I-1] + Y[I-1];
            }  
            if (FLAG == 2) {
               solution.append(" "+K+"\t");
               for (I=1; I<=N; I++) solution.append(formatter.format(X[I-1])+"\t");
               solution.append(formatter.format(R)+"\n");
            }   
            /* STEP 6 */
            if (R < TOL) {
               OK = false;
               solution.append("Iteration "+K+" gives solution:\n");
               for (I=1; I<=N; I++) solution.append(formatter.format(X[I-1])+"\t");
               solution.append("\nto within tolerance "+ TOL+"\n");
            }   
            /* STEP 7 */
            else K++;
         }  
      }  
      if (K > NN) 
         /* STEP 8 */
         solution.append("Procedure does not converge in "+NN+" iterations\n");
             
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
		myParser.addVariable("y", yValue);
		myParser.addVariable("z", zValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(int I)
   {
    double f; f = 0;
    xValue = X[0];
    yValue = X[1];  
    zValue = X[2];  
   switch (I) {
      case 1:
          parseExp(expr1.getText());
          f = myParser.getValue(); 
         break;
      case 2:
          parseExp(expr2.getText());
          f = myParser.getValue(); 
         break;
      case 3:
          parseExp(expr3.getText());
          f = myParser.getValue(); 
         break;
   }   
   return f;
}

/*  P is the Jacobian Matrix  J(X)  */
  public double functnP(int I, int J)
   {
    double p; p = 0;
    xValue = X[0];
    yValue = X[1];  
    zValue = X[2];  
   switch (I) {
      case 1: 
         switch (J) {
            case 1:
                parseExp(expr4.getText());
                p = myParser.getValue(); 
               break;
            case 2:
                parseExp(expr5.getText());
                p = myParser.getValue(); 
               break;
            case 3:
                parseExp(expr6.getText());
                p = myParser.getValue(); 
               break;
         }     
         break;
      case 2:
         switch (J) {
            case 1:
                parseExp(expr7.getText());
                p = myParser.getValue(); 
               break;
            case 2:
                parseExp(expr8.getText());
                p = myParser.getValue(); 
               break;
            case 3:
                parseExp(expr9.getText());
                p = myParser.getValue(); 
               break;
         }     
         break;
      case 3:
         switch (J) {
            case 1:
                parseExp(expr10.getText());
                p = myParser.getValue(); 
               break;
            case 2:
                parseExp(expr11.getText());
                p = myParser.getValue(); 
               break;
            case 3:
                parseExp(expr12.getText());
                p = myParser.getValue(); 
               break;
         }     
         break;
   }
   return p;
}
   
 public void LINSYS()
   {
     int L,I,K,IR,IA,J,JA;
     double Z,C;

   K = N - 1;
   OK = true;
   I = 1;
   while (OK && (I <= K)) {
      Z = Math.abs(A[I-1][I-1]);
      IR = I;
      IA = I + 1;
      for (J=IA; J<=N; J++) 
         if (Math.abs(A[J-1][I-1]) > Z) {
            IR = J;
            Z = Math.abs(A[J-1][I-1]);
         }   
      if (Z <= 0) OK = false;
      else {
         if (IR != I) 
            for (J=I; J<=N+1; J++) {
               C = A[I-1][J-1];
               A[I-1][J-1] = A[IR-1][J-1];
               A[IR-1][J-1] = C;
            }
         for (J=IA; J<=N; J++) {
            C = A[J-1][I-1] / A[I-1][I-1];
            if (Math.abs(C) <= 0) C = 0.0;
            for (L=I; L<=N+1; L++) 
               A[J-1][L-1] = A[J-1][L-1] - C * A[I-1][L-1];
         }     
      }
      I++;
   }
   if (OK) {
      if (Math.abs(A[N-1][N-1]) <= 0) OK = false;
      else {
         Y[N-1] = A[N-1][N] / A[N-1][N-1];
         for (I=1; I<=K; I++) {
            J = N - I;
            JA = J + 1;
            C = A[J-1][N];
            for (L=JA; L<=N; L++) C = C - A[J-1][L-1] * Y[L-1];
            Y[J-1] = C / A[J-1][J-1];
         }  
      }  
   }
   if (!(OK)) solution.append("Linear system is singular\n");
}

  public boolean inputCheck()
   {
        String errorInfo;
          if (NN <= 0 ){
            solution.append("Iterations must be a positive integer. \n");
            OK = false;}

          if ((N < 2) || (N >3)){
            solution.append("You can only work with 2 or 3 non linear equations. \n");
            OK = false;}

          if (TOL <= 0){
            solution.append("Tolerance must be positive. \n");
            OK = false;}
          

          parseExp(expr1.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr3.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr4.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr5.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr6.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr7.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr8.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr9.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr10.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr11.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr12.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    intN = new JTextField(4);
    intNN = new JTextField(4);
    approxX = new JTextField(4);
    approxY = new JTextField(4);
    approxZ = new JTextField(4);
    tolerance = new JTextField(6);
    expr1 = new JTextField(20);
    expr2 = new JTextField(20);
    expr3 = new JTextField(20);
    expr4 = new JTextField(20);
    expr5 = new JTextField(20);
    expr6 = new JTextField(20);
    expr7 = new JTextField(20);
    expr8 = new JTextField(20);
    expr9 = new JTextField(20);
    expr10 = new JTextField(20);
    expr11 = new JTextField(20);
    expr12 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(8,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("f1(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr1); expr1.setText("3*x-cos(y*z) - 0.5");
    inputPanel.add(new JLabel("f2(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr2); expr2.setText("x^2 - 81*(y+0.1)^2 + sin(z) + 1.06");
    inputPanel.add(new JLabel("f3(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr3); expr3.setText("e^(-x*y) + 20*z + (10*pi-3)/3");

    inputPanel.add(new JLabel("P1x(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr4); expr4.setText("3");
    inputPanel.add(new JLabel("P1y(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr5); expr5.setText("z*sin(y*z)");
    inputPanel.add(new JLabel("P1z(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr6); expr6.setText("y*sin(y*z)");

    inputPanel.add(new JLabel("P2x(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr7); expr7.setText("2*x");
    inputPanel.add(new JLabel("P2y(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr8); expr8.setText("-162*(y+0.1)");
    inputPanel.add(new JLabel("P2z(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr9); expr9.setText("cos(z)");

    inputPanel.add(new JLabel("P3x(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr10); expr10.setText("-y*e^(-x*y)");
    inputPanel.add(new JLabel("P3y(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr11); expr11.setText("-x*e^(-x*y)");
    inputPanel.add(new JLabel("P3z(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr12); expr12.setText("20");


    inputPanel.add(new JLabel("Approx X =:", JLabel.RIGHT));
    inputPanel.add(approxX);
    inputPanel.add(new JLabel("Approx Y =:", JLabel.RIGHT));
    inputPanel.add(approxY);
    inputPanel.add(new JLabel("Approx Z =:", JLabel.RIGHT));
    inputPanel.add(approxZ);

    inputPanel.add(new JLabel("No of Equatns:", JLabel.RIGHT));
    inputPanel.add(intN);intN.setText("3");
    inputPanel.add(new JLabel("Iterations =:", JLabel.RIGHT));
    inputPanel.add(intNN);
    inputPanel.add(new JLabel(" TOL =:", JLabel.RIGHT));
    inputPanel.add(tolerance);

  
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
